/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SizeTest")
public class SizeTest
extends MultiHotRodServersTest {
    static final int NUM_SERVERS = 3;
    static final int SIZE = 20;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, new ConfigurationBuilder());
    }

    public void testLocalCacheSize() {
        String cacheName = "local-size";
        this.defineInAll(cacheName, new ConfigurationBuilder());
        RemoteCache remote = this.createClient(0).getCache(cacheName);
        this.populateCache((RemoteCache<Integer, Integer>)remote);
        AssertJUnit.assertEquals((int)20, (int)remote.size());
    }

    public void testReplicatedCacheSize() {
        String cacheName = "replicated-size";
        this.defineInAll(cacheName, SizeTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
    }

    public void testDistributeCacheSize() {
        String cacheName = "distributed-size";
        this.defineInAll(cacheName, SizeTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
    }

    public void testPersistentDistributedCacheSize() {
        String cacheName = "persistent-distributed-size";
        ConfigurationBuilder builder = SizeTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.eviction().size(1L);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)this)).getClass().getName()).shared(true)).purgeOnStartup(true);
        this.defineInAll(cacheName, builder);
        AssertJUnit.assertEquals((int)0, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)this.server(0).getCacheManager().getCache(cacheName).size());
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
    }

    private void populateCache(String cacheName) {
        for (int i = 0; i < 20; ++i) {
            ((RemoteCacheManager)this.clients.get(i % 3)).getCache(cacheName).put((Object)i, (Object)i);
        }
    }

    private void populateCache(RemoteCache<Integer, Integer> remote) {
        for (int i = 0; i < 20; ++i) {
            remote.put((Object)i, (Object)i);
        }
    }
}

