/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.CacheAdminTest")
public class CacheAdminTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)CacheAdminTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().index(Index.ALL).autoConfig(true);
        this.createHotRodServers(2, builder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(serverPort);
        builder.marshaller((Marshaller)new ProtoStreamMarshaller());
        return builder;
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        cm.defineConfiguration("template", builder.build());
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        this.servers.add(server);
        return server;
    }

    public void cacheCreateRemoveTest() {
        this.client(0).administration().createCache("newCache", "template");
        AssertJUnit.assertTrue((boolean)this.manager(0).cacheExists("newCache"));
        AssertJUnit.assertTrue((boolean)this.manager(1).cacheExists("newCache"));
        this.client(1).administration().removeCache("newCache");
        AssertJUnit.assertFalse((boolean)this.manager(0).cacheExists("newCache"));
        AssertJUnit.assertFalse((boolean)this.manager(1).cacheExists("newCache"));
    }

    public void cacheReindexTest() throws IOException {
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/sample_bank_account/bank.proto")));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
        this.client(0).administration().createCache("newCache", "template");
        RemoteCache cache = this.client(0).getCache("newCache");
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAccountIds(Collections.singleton(12));
        AddressPB address1 = new AddressPB();
        address1.setStreet("Dark Alley");
        address1.setPostCode("1234");
        user1.setAddresses(Collections.singletonList(address1));
        cache.withFlags(new Flag[]{Flag.SKIP_INDEXING}).put((Object)0, (Object)user1);
        this.verifyUserQuery((RemoteCache<Object, Object>)cache, 0);
        this.client(0).administration().reindexCache("newCache");
        this.verifyUserQuery((RemoteCache<Object, Object>)cache, 1);
        this.client(0).administration().removeCache("newCache");
    }

    private void verifyUserQuery(RemoteCache<Object, Object> cache, int count) {
        List users = Search.getQueryFactory(cache).create("from sample_bank_account.User where name='Tom'").list();
        AssertJUnit.assertEquals((int)count, (int)users.size());
    }
}

