/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.EmbeddedAccountMarshaller;
import org.infinispan.client.hotrod.marshall.EmbeddedTransactionMarshaller;
import org.infinispan.client.hotrod.marshall.EmbeddedUserMarshaller;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.TransactionPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.GenderMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.NotIndexedMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.EmbeddedCompatTest", groups={"functional"})
@CleanupAfterMethod
public class EmbeddedCompatTest
extends SingleCacheManagerTest {
    private static final String NOT_INDEXED_PROTO_SCHEMA = "package sample_bank_account;\n/* @Indexed(false) */\nmessage NotIndexed {\n\toptional string notIndexedField = 1;\n}\n";
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, Account> remoteCache;
    private Cache<?, ?> embeddedCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.createConfigBuilder();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.embeddedCache = this.cache.getAdvancedCache().withEncoding(IdentityEncoder.class);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        SerializationContext clientSerCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        MarshallerRegistration.registerMarshallers(clientSerCtx);
        clientSerCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"not_indexed.proto", (String)NOT_INDEXED_PROTO_SCHEMA));
        clientSerCtx.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("sample_bank_account/bank.proto", Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        protobufMetadataManager.registerProtofile("not_indexed.proto", NOT_INDEXED_PROTO_SCHEMA);
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFileErrors("sample_bank_account/bank.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFileErrors("not_indexed.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManager.getFilesWithErrors());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedAccountMarshaller());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedUserMarshaller());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedTransactionMarshaller());
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder createConfigBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller());
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        super.teardown();
    }

    public void testPutAndGet() throws Exception {
        AccountPB account = this.createAccountPB(1);
        this.remoteCache.put((Object)1, (Object)account);
        AssertJUnit.assertEquals((int)1, (int)this.embeddedCache.keySet().size());
        Object key = this.embeddedCache.keySet().iterator().next();
        Object localObject = this.embeddedCache.get(key);
        this.assertAccount((Account)localObject, AccountHS.class);
        Account fromRemoteCache = (Account)this.remoteCache.get((Object)1);
        this.assertAccount(fromRemoteCache, AccountPB.class);
    }

    public void testPutAndGetForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        AssertJUnit.assertEquals((int)1, (int)this.remoteCache.keySet().size());
        Map.Entry entry = (Map.Entry)this.remoteCache.entrySet().iterator().next();
        this.assertAccount((Account)entry.getValue(), AccountPB.class);
        Account fromEmbeddedCache = (Account)this.embeddedCache.get((Object)1);
        this.assertAccount(fromEmbeddedCache, AccountHS.class);
    }

    public void testRemoteQuery() throws Exception {
        AccountPB account = this.createAccountPB(1);
        this.remoteCache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from(AccountPB.class).having("description").like("%test%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        this.assertAccount((Account)list.get(0), AccountPB.class);
    }

    public void testRemoteQueryForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from(AccountPB.class).having("description").like("%test%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        this.assertAccount((Account)list.get(0), AccountPB.class);
    }

    public void testRemoteQueryForEmbeddedEntryOnNonIndexedField() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from(UserPB.class).having("notes").like("%567%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((String)"1234567890", (String)((User)list.get(0)).getNotes());
    }

    public void testRemoteQueryForEmbeddedEntryOnNonIndexedType() throws Exception {
        this.cache.put((Object)1, (Object)new NotIndexed("testing 123"));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from("sample_bank_account.NotIndexed").having("notIndexedField").like("%123%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }

    public void testRemoteQueryForEmbeddedEntryOnIndexedAndNonIndexedField() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from(UserPB.class).having("notes").like("%567%").and().having("surname").eq((Object)"test surname").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((String)"1234567890", (String)((User)list.get(0)).getNotes());
        AssertJUnit.assertEquals((String)"test surname", (String)((User)list.get(0)).getSurname());
    }

    public void testRemoteQueryWithProjectionsForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query query = qf.from(AccountPB.class).select(new String[]{"description", "id"}).having("description").like("%test%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)"test description", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)1, (Object)((Object[])list.get(0))[1]);
    }

    public void testRemoteFullTextQuery() {
        TransactionHS transaction = new TransactionHS();
        transaction.setId(3);
        transaction.setDescription("Hotel");
        transaction.setLongDescription("Expenses for Infinispan F2F meeting");
        transaction.setAccountId(2);
        transaction.setAmount(99.0);
        transaction.setDate(new Date(42L));
        transaction.setDebit(true);
        transaction.setValid(true);
        this.cache.put((Object)transaction.getId(), (Object)transaction);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query q = qf.create("from sample_bank_account.Transaction where longDescription:'f2f'");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    public void testEmbeddedLuceneQuery() throws Exception {
        AccountPB account = this.createAccountPB(1);
        this.remoteCache.put((Object)1, (Object)account);
        SearchManager searchManager = org.infinispan.query.Search.getSearchManager(this.embeddedCache);
        Query query = searchManager.buildQueryBuilderForClass(AccountHS.class).get().keyword().wildcard().onField("description").matching((Object)"*test*").createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(query, new Class[0]);
        List list = cacheQuery.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        this.assertAccount((Account)list.get(0), AccountHS.class);
    }

    public void testEmbeddedQueryForEmbeddedEntryOnNonIndexedField() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query query = qf.from(UserHS.class).having("notes").like("%567%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals(UserHS.class, ((User)list.get(0)).getClass());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((String)"1234567890", (String)((User)list.get(0)).getNotes());
    }

    public void testEmbeddedQueryForEmbeddedEntryOnNonIndexedType() throws Exception {
        this.cache.put((Object)1, (Object)new NotIndexed("testing 123"));
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query query = qf.from(NotIndexed.class).having("notIndexedField").like("%123%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }

    public void testEmbeddedQueryForEmbeddedEntryOnIndexedAndNonIndexedField() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query query = qf.from(UserHS.class).having("notes").like("%567%").and().having("surname").eq((Object)"test surname").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertNotNull(list.get(0));
        AssertJUnit.assertEquals(UserHS.class, ((User)list.get(0)).getClass());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((String)"1234567890", (String)((User)list.get(0)).getNotes());
        AssertJUnit.assertEquals((String)"test surname", (String)((User)list.get(0)).getSurname());
    }

    public void testIterationForRemote() throws Exception {
        IntStream.range(0, 10).forEach(id -> {
            Account cfr_ignored_0 = (Account)this.remoteCache.put((Object)id, (Object)this.createAccountPB(id));
        });
        CloseableIterator remoteUnfilteredIterator = this.remoteCache.retrieveEntries(null, null, 10);
        remoteUnfilteredIterator.forEachRemaining(e -> {
            Integer key = (Integer)e.getKey();
            AccountPB value = (AccountPB)e.getValue();
            AssertJUnit.assertTrue((key < 10 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((value.getId() == key.intValue() ? 1 : 0) != 0);
        });
        KeyValueFilterConverterFactory filterConverterFactory = () -> new AbstractKeyValueFilterConverter<Integer, Account, String>(){

            public String filterAndConvert(Integer key, Account value, Metadata metadata) {
                if (key % 2 == 0) {
                    return value.toString();
                }
                return null;
            }
        };
        this.hotRodServer.addKeyValueFilterConverterFactory("filterConverterFactory", filterConverterFactory);
        CloseableIterator remoteFilteredIterator = this.remoteCache.retrieveEntries("filterConverterFactory", null, 10);
        remoteFilteredIterator.forEachRemaining(e -> {
            Integer key = (Integer)e.getKey();
            String value = (String)e.getValue();
            AssertJUnit.assertTrue((key < 10 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((boolean)value.equals(this.createAccountHS(key).toString()));
        });
        Cache<?, ?> ourCache = this.embeddedCache;
        Iterator localUnfilteredIterator = ourCache.entrySet().stream().iterator();
        localUnfilteredIterator.forEachRemaining(e -> {
            Integer key = (Integer)e.getKey();
            AccountHS value = (AccountHS)e.getValue();
            AssertJUnit.assertTrue((key < 10 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((value.getId() == key.intValue() ? 1 : 0) != 0);
        });
    }

    public void testEqEmptyStringRemote() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query q = qf.from(UserPB.class).having("name").eq((Object)"").build();
        List list = q.list();
        AssertJUnit.assertTrue((boolean)list.isEmpty());
    }

    public void testEqSentenceRemote() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("John Doe's first bank account");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query q = qf.from(AccountPB.class).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
    }

    public void testEqEmptyStringEmbedded() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("test name");
        user.setSurname("test surname");
        user.setGender(User.Gender.MALE);
        user.setNotes("1234567890");
        this.cache.put((Object)1, (Object)user);
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query q = qf.from(UserHS.class).having("name").eq((Object)"").build();
        List list = q.list();
        AssertJUnit.assertTrue((boolean)list.isEmpty());
    }

    public void testEqSentenceEmbedded() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("John Doe's first bank account");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query q = qf.from(AccountHS.class).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
    }

    public void testDuplicateBooleanProjectionEmbedded() {
        TransactionHS transaction = new TransactionHS();
        transaction.setId(3);
        transaction.setDescription("Hotel");
        transaction.setAccountId(2);
        transaction.setAmount(45.0);
        transaction.setDate(new Date(42L));
        transaction.setDebit(true);
        transaction.setValid(true);
        this.cache.put((Object)transaction.getId(), (Object)transaction);
        QueryFactory qf = org.infinispan.query.Search.getQueryFactory((Cache)this.cache);
        org.infinispan.query.dsl.Query q = qf.from(TransactionHS.class).select(new String[]{"id", "isDebit", "isDebit"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[2]);
    }

    public void testDuplicateBooleanProjectionRemote() {
        TransactionHS transaction = new TransactionHS();
        transaction.setId(3);
        transaction.setDescription("Hotel");
        transaction.setAccountId(2);
        transaction.setAmount(45.0);
        transaction.setDate(new Date(42L));
        transaction.setDebit(true);
        transaction.setValid(true);
        this.cache.put((Object)transaction.getId(), (Object)transaction);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        org.infinispan.query.dsl.Query q = qf.from(TransactionPB.class).select(new String[]{"id", "isDebit", "isDebit"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[2]);
    }

    private AccountPB createAccountPB(int id) {
        AccountPB account = new AccountPB();
        account.setId(id);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        return account;
    }

    private AccountHS createAccountHS(int id) {
        AccountHS account = new AccountHS();
        account.setId(id);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        return account;
    }

    private void assertAccount(Account account, Class<?> cls) {
        AssertJUnit.assertNotNull((Object)account);
        AssertJUnit.assertEquals(cls, account.getClass());
        AssertJUnit.assertEquals((int)1, (int)account.getId());
        AssertJUnit.assertEquals((String)"test description", (String)account.getDescription());
        AssertJUnit.assertEquals((long)42L, (long)account.getCreationDate().getTime());
    }
}

