/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.client.hotrod.counter.impl.ConnectionManager;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;

public class NotificationManager {
    private static final Log log = LogFactory.getLog(NotificationManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConnectionManager connectionManager;
    private final Map<String, List<HandleImpl<?>>> clientListeners;

    NotificationManager(CounterOperationFactory factory) {
        this.connectionManager = new ConnectionManager(factory, this::onEvent);
        this.clientListeners = new ConcurrentHashMap();
    }

    public <T extends CounterListener> Handle<T> addListener(String counterName, T listener) {
        if (trace) {
            log.tracef("Add listener for counter '%s'", counterName);
        }
        HandleImpl handle = new HandleImpl(this, counterName, listener);
        this.clientListeners.compute(counterName, (name, list) -> this.addToList((String)name, (List<HandleImpl<?>>)list, handle));
        return handle;
    }

    public void stop() {
        if (this.clientListeners.isEmpty()) {
            return;
        }
        this.clientListeners.clear();
        this.connectionManager.stop();
    }

    void failedServer(Set<SocketAddress> socketAddresses) {
        this.connectionManager.failedServers(socketAddresses);
    }

    private void onEvent(HotRodCounterEvent event) {
        if (trace) {
            log.tracef("Received counter event %s", event);
        }
        this.clientListeners.getOrDefault(event.getCounterName(), Collections.emptyList()).parallelStream().forEach(handle -> ((HandleImpl)handle).onEvent(event));
    }

    private List<HandleImpl<?>> addToList(String counterName, List<HandleImpl<?>> list, HandleImpl<?> handle) {
        if (list == null) {
            this.connectionManager.addConnection(counterName);
            list = new CopyOnWriteArrayList();
        }
        list.add(handle);
        return list;
    }

    private void removeListener(String counterName, HandleImpl<?> handle) {
        if (trace) {
            log.tracef("Remove listener for counter '%s'", counterName);
        }
        this.clientListeners.compute(counterName, (name, list) -> this.removeFromList((String)name, (List<HandleImpl<?>>)list, handle));
    }

    private List<HandleImpl<?>> removeFromList(String counterName, List<HandleImpl<?>> list, HandleImpl<?> handle) {
        list.remove(handle);
        if (list.isEmpty()) {
            list = null;
            this.connectionManager.removeConnection(counterName);
        }
        return list;
    }

    private static class HandleImpl<T extends CounterListener>
    implements Handle<T> {
        private final T listener;
        private final String counterName;
        final /* synthetic */ NotificationManager this$0;

        private HandleImpl(String counterName, T listener) {
            this.this$0 = var1_1;
            this.counterName = counterName;
            this.listener = listener;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.this$0.removeListener(this.counterName, this);
        }

        private void onEvent(CounterEvent event) {
            try {
                this.listener.onUpdate(event);
            }
            catch (Throwable t) {
                log.debug("Exception in user listener", t);
            }
        }
    }
}

