/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.impl.CounterHelper;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.client.hotrod.counter.impl.StrongCounterImpl;
import org.infinispan.client.hotrod.counter.impl.WeakCounterImpl;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterException;

public class RemoteCounterManager
implements CounterManager,
Consumer<Set<SocketAddress>> {
    private static final Log commonsLog = LogFactory.getLog(RemoteCounterManager.class, Log.class);
    private final Map<String, Object> counters = new ConcurrentHashMap<String, Object>();
    private CounterOperationFactory factory;
    private ExecutorService executorService;
    private CounterHelper counterHelper;
    private NotificationManager notificationManager;

    public void start(TransportFactory transportFactory, Codec codec, Configuration configuration, ExecutorService executorService) {
        this.factory = new CounterOperationFactory(configuration, transportFactory, codec);
        this.executorService = executorService;
        this.counterHelper = new CounterHelper(this.factory);
        this.notificationManager = new NotificationManager(this.factory);
    }

    public StrongCounter getStrongCounter(String name) {
        return this.getOrCreateCounter(name, StrongCounter.class, this::createStrongCounter, () -> commonsLog.invalidCounterType("Strong", "Weak"));
    }

    public WeakCounter getWeakCounter(String name) {
        return this.getOrCreateCounter(name, WeakCounter.class, this::createWeakCounter, () -> commonsLog.invalidCounterType("Weak", "Strong"));
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        return (Boolean)this.factory.newDefineCounterOperation(name, configuration).execute();
    }

    public boolean isDefined(String name) {
        return (Boolean)this.factory.newIsDefinedOperation(name).execute();
    }

    public CounterConfiguration getConfiguration(String counterName) {
        return (CounterConfiguration)this.factory.newGetConfigurationOperation(counterName).execute();
    }

    public void remove(String counterName) {
        this.factory.newRemoveOperation(counterName).execute();
    }

    public Collection<String> getCounterNames() {
        return (Collection)this.factory.newGetCounterNamesOperation().execute();
    }

    @Override
    public void accept(Set<SocketAddress> socketAddresses) {
        if (this.notificationManager != null) {
            this.notificationManager.failedServer(socketAddresses);
        }
    }

    public void stop() {
        if (this.notificationManager != null) {
            this.notificationManager.stop();
        }
    }

    private <T> T getOrCreateCounter(String name, Class<T> tClass, Function<String, T> createFunction, Supplier<CounterException> invalidCounter) {
        Object counter = this.counters.computeIfAbsent(name, createFunction);
        if (!tClass.isInstance(counter)) {
            throw invalidCounter.get();
        }
        return tClass.cast(counter);
    }

    private void assertWeakCounter(CounterConfiguration configuration) {
        if (configuration.type() != CounterType.WEAK) {
            throw commonsLog.invalidCounterType("Weak", "Strong");
        }
    }

    private WeakCounter createWeakCounter(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw commonsLog.undefinedCounter(counterName);
        }
        this.assertWeakCounter(configuration);
        return new WeakCounterImpl(counterName, configuration, this.executorService, this.counterHelper, this.notificationManager);
    }

    private StrongCounter createStrongCounter(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw commonsLog.undefinedCounter(counterName);
        }
        this.assertStrongCounter(configuration);
        return new StrongCounterImpl(counterName, configuration, this.executorService, this.counterHelper, this.notificationManager);
    }

    private void assertStrongCounter(CounterConfiguration configuration) {
        if (configuration.type() == CounterType.WEAK) {
            throw commonsLog.invalidCounterType("Strong", "Weak");
        }
    }
}

