/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.counter.impl.CounterHelper;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;

class StrongCounterImpl
implements StrongCounter {
    private final String name;
    private final CounterConfiguration configuration;
    private final ExecutorService executorService;
    private final CounterHelper counterHelper;
    private final SyncStrongCounter syncCounter;
    private final NotificationManager notificationManager;

    StrongCounterImpl(String name, CounterConfiguration configuration, ExecutorService executorService, CounterHelper counterHelper, NotificationManager notificationManager) {
        this.name = name;
        this.configuration = configuration;
        this.executorService = executorService;
        this.counterHelper = counterHelper;
        this.notificationManager = notificationManager;
        this.syncCounter = new Sync();
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Long> getValue() {
        return CompletableFuture.supplyAsync(() -> ((SyncStrongCounter)this.syncCounter).getValue(), this.executorService);
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        return CompletableFuture.supplyAsync(() -> this.syncCounter.addAndGet(delta), this.executorService);
    }

    public CompletableFuture<Void> reset() {
        return CompletableFuture.runAsync(() -> ((SyncStrongCounter)this.syncCounter).reset(), this.executorService);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(this.name, listener);
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        return CompletableFuture.supplyAsync(() -> this.syncCounter.compareAndSwap(expect, update), this.executorService);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompletableFuture<Void> remove() {
        return CompletableFuture.runAsync(() -> ((SyncStrongCounter)this.syncCounter).remove(), this.executorService);
    }

    public SyncStrongCounter sync() {
        return this.syncCounter;
    }

    private class Sync
    implements SyncStrongCounter {
        private Sync() {
        }

        public long addAndGet(long delta) {
            return StrongCounterImpl.this.counterHelper.addAndGet(StrongCounterImpl.this.name, delta);
        }

        public void reset() {
            StrongCounterImpl.this.counterHelper.reset(StrongCounterImpl.this.name);
        }

        public long getValue() {
            return StrongCounterImpl.this.counterHelper.getValue(StrongCounterImpl.this.name);
        }

        public long compareAndSwap(long expect, long update) {
            return StrongCounterImpl.this.counterHelper.compareAndSwap(StrongCounterImpl.this.name, expect, update, StrongCounterImpl.this.configuration);
        }

        public String getName() {
            return StrongCounterImpl.this.name;
        }

        public CounterConfiguration getConfiguration() {
            return StrongCounterImpl.this.configuration;
        }

        public void remove() {
            StrongCounterImpl.this.counterHelper.remove(StrongCounterImpl.this.name);
        }
    }
}

