/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.counter.impl.CounterHelper;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;

class WeakCounterImpl
implements WeakCounter {
    private final String name;
    private final CounterConfiguration configuration;
    private final ExecutorService executorService;
    private final CounterHelper counterHelper;
    private final SyncWeakCounter syncCounter;
    private final NotificationManager notificationManager;

    WeakCounterImpl(String name, CounterConfiguration configuration, ExecutorService executorService, CounterHelper counterHelper, NotificationManager notificationManager) {
        this.name = name;
        this.configuration = configuration;
        this.executorService = executorService;
        this.counterHelper = counterHelper;
        this.notificationManager = notificationManager;
        this.syncCounter = new Sync();
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.counterHelper.getValue(this.name);
    }

    public CompletableFuture<Void> add(long delta) {
        return CompletableFuture.runAsync(() -> this.syncCounter.add(delta), this.executorService);
    }

    public CompletableFuture<Void> reset() {
        return CompletableFuture.runAsync(() -> ((SyncWeakCounter)this.syncCounter).reset(), this.executorService);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(this.name, listener);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompletableFuture<Void> remove() {
        return CompletableFuture.runAsync(() -> ((SyncWeakCounter)this.syncCounter).remove(), this.executorService);
    }

    public SyncWeakCounter sync() {
        return this.syncCounter;
    }

    private class Sync
    implements SyncWeakCounter {
        private Sync() {
        }

        public String getName() {
            return WeakCounterImpl.this.name;
        }

        public long getValue() {
            return WeakCounterImpl.this.counterHelper.getValue(WeakCounterImpl.this.name);
        }

        public void add(long delta) {
            WeakCounterImpl.this.counterHelper.addAndGet(WeakCounterImpl.this.name, delta);
        }

        public void reset() {
            WeakCounterImpl.this.counterHelper.reset(WeakCounterImpl.this.name);
        }

        public CounterConfiguration getConfiguration() {
            return WeakCounterImpl.this.configuration;
        }

        public void remove() {
            WeakCounterImpl.this.counterHelper.remove(WeakCounterImpl.this.name);
        }
    }
}

