/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class AddOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(AddOperation.class, Log.class);
    private final long delta;

    public AddOperation(Codec codec, TransportFactory transportFactory, AtomicInteger topologyId, Configuration cfg, String counterName, long delta) {
        super(codec, transportFactory, topologyId, cfg, counterName);
        this.delta = delta;
    }

    @Override
    protected Long executeOperation(Transport transport) {
        HeaderParams params = this.writeHeaderAndCounterName(transport, (short)82);
        transport.writeLong(this.delta);
        transport.flush();
        short status = this.readHeaderAndValidateCounter(transport, params);
        this.assertBoundaries(status);
        assert (status == 0);
        return transport.readLong();
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.delta > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

