/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.logging.Log;

abstract class BaseCounterOperation<T>
extends RetryOnFailureOperation<T> {
    private static final Log commonsLog = LogFactory.getLog(BaseCounterOperation.class, Log.class);
    private static final byte[] EMPTY_CACHE_NAME = new byte[0];
    private static final byte[] COUNTER_CACHE_NAME = RemoteCacheManager.cacheNameBytes("org.infinispan.counter");
    private final String counterName;

    BaseCounterOperation(Codec codec, TransportFactory transportFactory, AtomicInteger topologyId, Configuration cfg, String counterName) {
        super(codec, transportFactory, EMPTY_CACHE_NAME, topologyId, 0, cfg);
        this.counterName = counterName;
    }

    HeaderParams writeHeaderAndCounterName(Transport transport, short opCode) {
        HeaderParams params = this.writeHeader(transport, opCode);
        transport.writeString(this.counterName);
        return params;
    }

    short readHeaderAndValidateCounter(Transport transport, HeaderParams headerParams) {
        this.setCacheName(headerParams);
        short status = this.readHeaderAndValidate(transport, headerParams);
        if (status == 2) {
            throw commonsLog.undefinedCounter(this.counterName);
        }
        return status;
    }

    void setCacheName(HeaderParams params) {
        params.cacheName(COUNTER_CACHE_NAME);
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, COUNTER_CACHE_NAME);
    }
}

