/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class GetKeyMultimapOperation<V>
extends AbstractMultimapKeyOperation<Collection<V>> {
    public GetKeyMultimapOperation(Codec codec, TransportFactory transportFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, transportFactory, key, keyBytes, cacheName, topologyId, flags, cfg);
    }

    @Override
    protected Collection<V> executeOperation(Transport transport) {
        Set result;
        short status = this.sendKeyOperation(this.keyBytes, transport, (short)103, (short)104);
        if (HotRodConstants.isNotExist(status)) {
            result = Collections.emptySet();
        } else {
            int size = transport.readVInt();
            result = new HashSet(size);
            for (int i = 0; i < size; ++i) {
                Object value = this.codec.readUnmarshallByteArray(transport, status, this.cfg.serialWhitelist());
                result.add(value);
            }
        }
        return result;
    }
}

