/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.SizeMultimapOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class MultimapOperationsFactory {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final TransportFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;
    private final Codec codec;
    private final Configuration cfg;

    public MultimapOperationsFactory(TransportFactory transportFactory, String cacheName, Codec codec, Configuration cfg) {
        this.transportFactory = transportFactory;
        this.cacheNameBytes = cacheName == null ? null : RemoteCacheManager.cacheNameBytes(cacheName);
        this.topologyId = transportFactory != null ? transportFactory.createTopologyId(this.cacheNameBytes) : new AtomicInteger(-1);
        this.forceReturnValue = cfg.forceReturnValues();
        this.codec = codec;
        this.cfg = cfg;
    }

    public <K, V> GetKeyMultimapOperation<V> newGetKeyMultimapOperation(K key, byte[] keyBytes) {
        return new GetKeyMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <K, V> GetKeyWithMetadataMultimapOperation<V> newGetKeyWithMetadataMultimapOperation(K key, byte[] keyBytes) {
        return new GetKeyWithMetadataMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <K> PutKeyValueMultimapOperation<Void> newPutKeyValueOperation(K key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new PutKeyValueMultimapOperation<Void>(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public <K> RemoveKeyMultimapOperation newRemoveKeyOperation(K key, byte[] keyBytes) {
        return new RemoveKeyMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <K, V> RemoveEntryMultimapOperation newRemoveEntryOperation(K key, byte[] keyBytes, byte[] value) {
        return new RemoveEntryMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, value);
    }

    public <K, V> ContainsEntryMultimapOperation newContainsEntryOperation(K key, byte[] keyBytes, byte[] value) {
        return new ContainsEntryMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, value);
    }

    public <K> ContainsKeyMultimapOperation newContainsKeyOperation(K key, byte[] keyBytes) {
        return new ContainsKeyMultimapOperation(this.codec, this.transportFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <V> ContainsValueMultimapOperation newContainsValueOperation(byte[] value) {
        return new ContainsValueMultimapOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, value, -1L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS);
    }

    public SizeMultimapOperation newSizeOperation() {
        return new SizeMultimapOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }
}

