/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.jboss.logging.BasicLogger;

@Immutable
public class PutIfAbsentOperation<V>
extends AbstractKeyValueOperation<V> {
    private static final BasicLogger log = LogFactory.getLog(PutIfAbsentOperation.class);
    private static final boolean trace = log.isTraceEnabled();

    public PutIfAbsentOperation(Codec codec, TransportFactory transportFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super(codec, transportFactory, key, keyBytes, cacheName, topologyId, flags, cfg, value, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    protected V executeOperation(Transport transport) {
        short status = this.sendKeyValueOperation(transport, (short)5, (byte)6);
        V previousValue = null;
        if (HotRodConstants.isNotExecuted(status)) {
            previousValue = (V)this.returnPossiblePrevValue(transport, status);
            if (trace) {
                log.tracef("Returning from putIfAbsent: %s", previousValue);
            }
        }
        return previousValue;
    }
}

