/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.WorkerThread;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientConnectionPoolingTest", groups={"functional"})
public class ClientConnectionPoolingTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(ClientConnectionPoolingTest.class);
    Cache<String, String> c1;
    Cache<String, String> c2;
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private ChannelFactory channelFactory;
    private InetSocketAddress hrServ1Addr;
    private InetSocketAddress hrServ2Addr;
    private WorkerThread workerThread1;
    private WorkerThread workerThread2;
    private WorkerThread workerThread3;
    private WorkerThread workerThread4;
    private WorkerThread workerThread5;
    private WorkerThread workerThread6;

    protected void createCacheManagers() throws Throwable {
        this.c1 = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration()).getCache();
        this.c2 = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration()).getCache();
        this.registerCacheManager(new CacheContainer[]{this.c1.getCacheManager(), this.c2.getCacheManager()});
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.c1.getCacheManager());
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.c2.getCacheManager());
        String servers = HotRodClientTestingUtil.getServersString(this.hotRodServer1, this.hotRodServer2);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.connectionPool().maxActive(2).exhaustedAction(ExhaustedAction.WAIT).minEvictableIdleTime(7000L).minIdle(-5).addServers(servers);
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.channelFactory = ((InternalRemoteCacheManager)this.remoteCacheManager).getChannelFactory();
        this.workerThread1 = new WorkerThread(this.remoteCache);
        this.workerThread2 = new WorkerThread(this.remoteCache);
        this.workerThread3 = new WorkerThread(this.remoteCache);
        this.workerThread4 = new WorkerThread(this.remoteCache);
        this.workerThread5 = new WorkerThread(this.remoteCache);
        this.workerThread6 = new WorkerThread(this.remoteCache);
        this.hrServ1Addr = InetSocketAddress.createUnresolved("localhost", this.hotRodServer1.getPort());
        this.hrServ2Addr = InetSocketAddress.createUnresolved("localhost", this.hotRodServer2.getPort());
    }

    @AfterMethod
    public void tearDown() throws ExecutionException, InterruptedException {
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2);
        this.workerThread1.stop();
        this.workerThread2.stop();
        this.workerThread3.stop();
        this.workerThread4.stop();
        this.workerThread5.stop();
        this.workerThread6.stop();
        this.workerThread1.awaitTermination();
        this.workerThread2.awaitTermination();
        this.workerThread3.awaitTermination();
        this.workerThread4.awaitTermination();
        this.workerThread5.awaitTermination();
        this.workerThread6.awaitTermination();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxActiveReached() throws Exception {
        this.workerThread1.put("k1", "v1");
        this.workerThread1.put("k2", "v2");
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ2Addr));
        AssertJUnit.assertEquals((int)1, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)1, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ2Addr));
        DelayTransportInterceptor dt1 = new DelayTransportInterceptor(true);
        DelayTransportInterceptor dt2 = new DelayTransportInterceptor(true);
        this.c1.getAdvancedCache().addInterceptor((CommandInterceptor)dt1, 0);
        this.c2.getAdvancedCache().addInterceptor((CommandInterceptor)dt2, 0);
        log.info((Object)"Cache operations blocked");
        try {
            this.workerThread1.putAsync("k3", "v3");
            this.workerThread2.putAsync("k4", "v4");
            log.info((Object)"Async calls for k3 and k4 is done.");
            this.eventually(() -> 1 == this.channelFactory.getNumActive((SocketAddress)this.hrServ1Addr) && 1 == this.channelFactory.getNumActive((SocketAddress)this.hrServ2Addr) && 0 == this.channelFactory.getNumIdle((SocketAddress)this.hrServ1Addr) && 0 == this.channelFactory.getNumIdle((SocketAddress)this.hrServ2Addr));
            this.workerThread3.putAsync("k5", "v5");
            this.workerThread4.putAsync("k6", "v6");
            this.eventually(() -> 2 == this.channelFactory.getNumActive((SocketAddress)this.hrServ1Addr) && 2 == this.channelFactory.getNumActive((SocketAddress)this.hrServ2Addr) && 0 == this.channelFactory.getNumIdle((SocketAddress)this.hrServ1Addr) && 0 == this.channelFactory.getNumIdle((SocketAddress)this.hrServ2Addr));
            this.workerThread5.putAsync("k7", "v7");
            this.workerThread6.putAsync("k8", "v8");
            Thread.sleep(2000L);
            AssertJUnit.assertEquals((int)2, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ1Addr));
            AssertJUnit.assertEquals((int)2, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ2Addr));
            AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ1Addr));
            AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ2Addr));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            dt1.allow();
            dt2.allow();
        }
        this.eventually(() -> this.channelFactory.getNumActive() == 0, 1000L);
        this.assertExistKeyValue("k3", "v3");
        this.assertExistKeyValue("k4", "v4");
        this.assertExistKeyValue("k5", "v5");
        this.assertExistKeyValue("k6", "v6");
        this.assertExistKeyValue("k7", "v7");
        this.assertExistKeyValue("k8", "v8");
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)this.hrServ2Addr));
        AssertJUnit.assertEquals((int)2, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)2, (int)this.channelFactory.getNumIdle((SocketAddress)this.hrServ2Addr));
    }

    private void assertExistKeyValue(String key, String value) throws InterruptedException {
        boolean exists = false;
        for (int i = 0; i < 10; ++i) {
            boolean bl = exists = value.equals(this.remoteCache.get((Object)key)) || value.equals(this.remoteCache.get((Object)key));
            if (exists) break;
            Thread.sleep(1000L);
        }
        AssertJUnit.assertEquals((String)("key value not found: (" + key + ", " + value + ")"), (boolean)true, (boolean)exists);
    }

    public static class DelayTransportInterceptor
    extends CommandInterceptor {
        private final ReentrantLock lock = new ReentrantLock();

        public DelayTransportInterceptor(boolean lock) {
            if (lock) {
                this.block();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            log.trace((Object)("Acquiring lock. " + this.lockInfo()));
            this.lock.lock();
            try {
                Object object = super.handleDefault(ctx, command);
                return object;
            }
            finally {
                log.trace((Object)("Done operation, releasing lock" + this.lockInfo()));
                this.lock.unlock();
            }
        }

        private String lockInfo() {
            return " Is locked? " + this.lock.isLocked() + ". Lock held by me? " + this.lock.isHeldByCurrentThread();
        }

        public void block() {
            log.trace((Object)("block. " + this.lockInfo()));
            this.lock.lock();
        }

        public void allow() {
            log.trace((Object)("allow." + this.lockInfo()));
            this.lock.unlock();
        }
    }
}

