/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.WorkerThread;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HeavyLoadConnectionPoolingTest", groups={"functional"})
public class HeavyLoadConnectionPoolingTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private ChannelFactory channelFactory;

    @AfterMethod
    protected void clearContent() {
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.cache.getAdvancedCache().addInterceptor((CommandInterceptor)new ConstantDelayTransportInterceptor(100), 0);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.connectionPool().timeBetweenEvictionRuns(500L).minEvictableIdleTime(100L).numTestsPerEvictionRun(10).minIdle(0).addServer().host("localhost").port(this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.channelFactory = (ChannelFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"channelFactory");
        return this.cacheManager;
    }

    @AfterClass
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testHeavyLoad() throws InterruptedException, ExecutionException {
        ArrayList<WorkerThread> workers = new ArrayList<WorkerThread>();
        for (int i = 0; i < 20; ++i) {
            WorkerThread workerThread = new WorkerThread(this.remoteCache);
            workers.add(workerThread);
            workerThread.stress();
        }
        while (this.channelFactory.getNumActive() <= 15) {
            Thread.sleep(10L);
        }
        for (WorkerThread wt : workers) {
            wt.stop();
        }
        for (WorkerThread wt : workers) {
            wt.awaitTermination();
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                int numIdle = HeavyLoadConnectionPoolingTest.this.channelFactory.getNumIdle();
                int numActive = HeavyLoadConnectionPoolingTest.this.channelFactory.getNumActive();
                return numIdle == 0 && numActive == 0;
            }
        });
    }

    public static class ConstantDelayTransportInterceptor
    extends CommandInterceptor {
        private int millis;

        public ConstantDelayTransportInterceptor(int millis) {
            this.millis = millis;
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            Thread.sleep(this.millis);
            return super.handleDefault(ctx, command);
        }
    }
}

