/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public abstract class BaseIterationFailOverTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    protected final int SERVERS = 3;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    public abstract ConfigurationBuilder getCacheConfiguration();

    @Test
    public void testFailOver() throws InterruptedException {
        int cacheSize = 10000;
        int batch = 17;
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(cacheSize, this::newAccount, cache);
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        CloseableIterator iterator = cache.retrieveEntries(null, null, batch);
        for (int i = 0; i < cacheSize / 2; ++i) {
            Map.Entry next = (Map.Entry)iterator.next();
            entries.add(next);
        }
        this.killIterationServer();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            entries.add(next);
        }
        AssertJUnit.assertEquals((int)cacheSize, (int)entries.size());
        Set keys = this.extractKeys(entries);
        AssertJUnit.assertEquals((Object)this.rangeAsSet(0, cacheSize), (Object)keys);
    }

    protected void killIterationServer() {
        this.servers.stream().filter(s -> s.getIterationManager().activeIterations() > 0).forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0));
    }
}

