/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.retry.GetAllRetryTest", groups={"functional"})
public class GetAllRetryTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)GetAllRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
    }

    @Override
    protected int maxRetries() {
        return 10;
    }

    @Test
    public void testFailOver() throws InterruptedException {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        int size = 1000;
        IntStream.range(0, size).forEach(num -> {
            String cfr_ignored_0 = (String)remoteCache.put((Object)num, (Object)("value" + num));
        });
        Map firstBatch = remoteCache.getAll(IntStream.range(0, size / 2).boxed().collect(Collectors.toSet()));
        HotRodClientTestingUtil.killServers((HotRodServer)this.servers.get(0));
        Map secondBatch = remoteCache.getAll(IntStream.range(size / 2, size).boxed().collect(Collectors.toSet()));
        AssertJUnit.assertEquals((int)size, (int)(firstBatch.size() + secondBatch.size()));
    }
}

