/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.BulkOperationsTest")
public class BulkOperationsTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected ControlledTimeService timeService;

    public Object[] factory() {
        return new Object[]{new BulkOperationsTest().cacheMode(CacheMode.DIST_SYNC), new BulkOperationsTest().cacheMode(CacheMode.REPL_SYNC), new BulkOperationsTest().cacheMode(CacheMode.LOCAL)};
    }

    protected int numberOfHotRodServers() {
        return this.cacheMode.isClustered() ? 3 : 1;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)(this.cacheMode.isClustered() ? BulkOperationsTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false) : new org.infinispan.configuration.cache.ConfigurationBuilder()));
    }

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        this.timeService = new ControlledTimeService();
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
            TestingUtil.replaceComponent((Cache)cm.getCache(), TimeService.class, (Object)this.timeService, (boolean)true);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterMethod
    public void checkNoActiveIterations() {
        for (HotRodServer hotRodServer : this.hotrodServers) {
            AssertJUnit.assertEquals((int)0, (int)hotRodServer.getIterationManager().activeIterations());
        }
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    protected void populateCacheManager() {
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)i, (Object)i);
        }
    }

    @DataProvider(name="collections-item")
    public Object[][] collectionItemProvider() {
        return new Object[][]{{RemoteCache::keySet, Function.identity()}, {RemoteCache::values, Function.identity()}, {RemoteCache::entrySet, o -> new AbstractMap.SimpleEntry<Object, Object>(o, o)}};
    }

    @Test(dataProvider="collections-item")
    public void testContains(Function<RemoteCache<?, ?>, Collection<?>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<?> collection = collFunction.apply(this.remoteCache);
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)collection.contains(itemFunction.apply(i)));
        }
        AssertJUnit.assertFalse((boolean)collection.contains(itemFunction.apply(104)));
        AssertJUnit.assertFalse((boolean)collection.contains(itemFunction.apply(-1)));
    }

    @Test(dataProvider="collections-item")
    public void testContainsAll(Function<RemoteCache<?, ?>, Collection<?>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<Object> collection = collFunction.apply(this.remoteCache);
        AssertJUnit.assertFalse((boolean)collection.containsAll(Arrays.asList(itemFunction.apply(204), itemFunction.apply(4))));
        AssertJUnit.assertTrue((boolean)collection.containsAll(Arrays.asList(itemFunction.apply(4), itemFunction.apply(10))));
        AssertJUnit.assertTrue((boolean)collection.containsAll(IntStream.range(0, 100).mapToObj(itemFunction::apply).collect(Collectors.toList())));
    }

    @Test(dataProvider="collections-item")
    public void testRemove(Function<RemoteCache<?, ?>, Collection<?>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<?> collection = collFunction.apply(this.remoteCache);
        collection.remove(itemFunction.apply(4));
        collection.remove(itemFunction.apply(23));
        collection.remove(itemFunction.apply(1001));
        AssertJUnit.assertEquals((int)98, (int)collection.size());
    }

    @Test(dataProvider="collections-item")
    public void testRemoveAll(Function<RemoteCache<?, ?>, Collection<Object>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<Object> collection = collFunction.apply(this.remoteCache);
        collection.removeAll(Arrays.asList(itemFunction.apply(5), itemFunction.apply(10), itemFunction.apply(23), itemFunction.apply(18), itemFunction.apply(105)));
        AssertJUnit.assertEquals((int)96, (int)collection.size());
        collection.removeAll(Arrays.asList(itemFunction.apply(5), itemFunction.apply(890)));
        AssertJUnit.assertEquals((int)96, (int)collection.size());
    }

    @Test(dataProvider="collections-item")
    public void testRetainAll(Function<RemoteCache<?, ?>, Collection<?>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<Object> collection = collFunction.apply(this.remoteCache);
        collection.retainAll(Arrays.asList(itemFunction.apply(1), itemFunction.apply(23), itemFunction.apply(102)));
        AssertJUnit.assertEquals((int)2, (int)collection.size());
    }

    @Test(dataProvider="collections-item", expectedExceptions={UnsupportedOperationException.class})
    public void testAdd(Function<RemoteCache<?, ?>, CloseableIteratorCollection<Object>> function, Function<Object, Object> itemFunction) {
        CloseableIteratorCollection<Object> collection = function.apply(this.remoteCache);
        collection.add(itemFunction.apply(1));
    }

    @Test(dataProvider="collections-item", expectedExceptions={UnsupportedOperationException.class})
    public void testAddAll(Function<RemoteCache<?, ?>, CloseableIteratorCollection<Object>> function, Function<Object, Object> itemFunction) {
        CloseableIteratorCollection<Object> collection = function.apply(this.remoteCache);
        collection.addAll(Arrays.asList(itemFunction.apply(1), itemFunction.apply(2)));
    }

    @Test(dataProvider="collections-item")
    public void testStreamAll(Function<RemoteCache<?, ?>, Collection<Object>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<Object> collection = collFunction.apply(this.remoteCache);
        List strings = collection.stream().map(Object::toString).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)100, (int)strings.size());
        AssertJUnit.assertEquals((long)100L, (long)collection.parallelStream().count());
    }

    @Test(dataProvider="collections-item")
    public void testStreamShortCircuit(Function<RemoteCache<?, ?>, Collection<Object>> collFunction, Function<Object, Object> itemFunction) {
        this.populateCacheManager();
        Collection<Object> collection = collFunction.apply(this.remoteCache);
        try (Stream<Object> stream = collection.stream();){
            AssertJUnit.assertEquals((boolean)false, (boolean)stream.allMatch(o -> Objects.equals(o, itemFunction.apply(1))));
        }
        stream = collection.parallelStream();
        var5_5 = null;
        try {
            AssertJUnit.assertEquals((Object)itemFunction.apply(4), (Object)stream.filter(o -> Objects.equals(o, itemFunction.apply(4))).findAny().get());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var5_5 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @DataProvider(name="collections")
    public Object[][] collectionProvider() {
        return new Object[][]{{RemoteCache::entrySet}, {RemoteCache::keySet}, {RemoteCache::values}};
    }

    @Test(dataProvider="collections")
    public void testSizeWithExpiration(Function<RemoteCache<?, ?>, Collection<?>> function) {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long lifespan = 5000L;
        this.remoteCache.putAll(dataIn, 5000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((int)2, (int)function.apply(this.remoteCache).size());
        this.timeService.advance(5001L);
        AssertJUnit.assertEquals((int)0, (int)function.apply(this.remoteCache).size());
    }

    @Test(dataProvider="collections")
    public void testIteratorRemove(Function<RemoteCache<?, ?>, CloseableIteratorCollection<?>> function) {
        this.populateCacheManager();
        CloseableIteratorCollection<?> collection = function.apply(this.remoteCache);
        AssertJUnit.assertEquals((int)100, (int)collection.size());
        try (CloseableIterator iter = collection.iterator();){
            AssertJUnit.assertTrue((boolean)iter.hasNext());
            AssertJUnit.assertNotNull((Object)iter.next());
            Object removed = iter.next();
            AssertJUnit.assertNotNull((Object)removed);
            iter.remove();
            AssertJUnit.assertTrue((boolean)iter.hasNext());
        }
        AssertJUnit.assertEquals((int)99, (int)collection.size());
    }

    @Test(dataProvider="collections")
    public void testClear(Function<RemoteCache<?, ?>, CloseableIteratorCollection<?>> function) {
        this.populateCacheManager();
        CloseableIteratorCollection<?> collection = function.apply(this.remoteCache);
        AssertJUnit.assertEquals((int)100, (int)collection.size());
        collection.clear();
        AssertJUnit.assertEquals((int)0, (int)this.remoteCache.size());
    }
}

