/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.ExecTest")
public class ExecTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_CACHE = "___script_cache";
    static final String REPL_CACHE = "R";
    static final String DIST_CACHE = "D";
    static final int NUM_SERVERS = 2;
    static final int SIZE = 20;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, new ConfigurationBuilder());
        this.defineInAll(REPL_CACHE, CacheMode.REPL_SYNC);
        this.defineInAll(DIST_CACHE, CacheMode.DIST_SYNC);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        ((RemoteCacheManager)this.clients.get(0)).getCache(REPL_CACHE).clear();
        ((RemoteCacheManager)this.clients.get(0)).getCache(DIST_CACHE).clear();
    }

    private void defineInAll(String cacheName, CacheMode mode) {
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)mode, (boolean)true);
        builder.dataContainer().compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller()).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.defineInAll(cacheName, builder);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unknown task 'nonExistent\\.js'.*")
    public void testRemovingNonExistentScript() {
        ((RemoteCacheManager)this.clients.get(0)).getCache().execute("nonExistent.js", new HashMap());
    }

    @Test(dataProvider="CacheNameProvider")
    public void testEmbeddedScriptRemoteExecution(String cacheName) throws IOException {
        HotRodClientTestingUtil.withScript(this.manager(0), "/test.js", scriptName -> {
            this.populateCache(cacheName);
            AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("parameter", "guinness");
            Integer result = (Integer)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute(scriptName, params);
            AssertJUnit.assertEquals((int)21, (int)result);
            AssertJUnit.assertEquals((Object)"guinness", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"parameter"));
        });
    }

    @Test(dataProvider="CacheNameProvider")
    public void testRemoteScriptRemoteExecution(String cacheName) throws IOException {
        HotRodClientTestingUtil.withScript(this.manager(0), "/test.js", scriptName -> {
            this.populateCache(cacheName);
            AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("parameter", "hoptimus prime");
            Integer result = (Integer)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute(scriptName, params);
            AssertJUnit.assertEquals((int)21, (int)result);
            AssertJUnit.assertEquals((Object)"hoptimus prime", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"parameter"));
        });
    }

    @Test(enabled=false, dataProvider="CacheModeProvider", description="Enable when ISPN-6300 is fixed.")
    public void testScriptExecutionWithPassingParams(CacheMode cacheMode) throws IOException {
        String cacheName = "testScriptExecutionWithPassingParams_" + cacheMode.toString();
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)cacheMode, (boolean)true);
        builder.dataContainer().compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/distExec.js");){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            this.manager(0).getCache(SCRIPT_CACHE).put((Object)"testScriptExecutionWithPassingParams.js", (Object)script);
        }
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "hoptimus prime");
        List result = (List)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute("testScriptExecutionWithPassingParams.js", params);
        AssertJUnit.assertEquals((int)21, (int)this.client(0).getCache(cacheName).size());
        AssertJUnit.assertEquals((Object)"hoptimus prime", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"a"));
        AssertJUnit.assertEquals((int)2, (int)result.size());
        AssertJUnit.assertTrue((boolean)result.contains(this.manager(0).getAddress()));
        AssertJUnit.assertTrue((boolean)result.contains(this.manager(1).getAddress()));
    }

    private void populateCache(String cacheName) {
        for (int i = 0; i < 20; ++i) {
            ((RemoteCacheManager)this.clients.get(i % 2)).getCache(cacheName).put((Object)String.format("Key %d", i), (Object)String.format("Value %d", i));
        }
    }

    @Test(enabled=false, dataProvider="CacheModeProvider", description="Disabling this test until the distributed scripts in DIST mode are fixed - ISPN-6173")
    public void testRemoteMapReduceWithStreams(CacheMode cacheMode) throws Exception {
        String cacheName = "testRemoteMapReduce_Streams_dist_" + cacheMode.toString();
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)cacheMode, (boolean)true);
        builder.dataContainer().compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        this.waitForClusterToForm(cacheName);
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName);
        RemoteCache scriptCache = ((RemoteCacheManager)this.clients.get(1)).getCache(SCRIPT_CACHE);
        ScriptingUtils.loadData((BasicCache)cache, (String)"/macbeth.txt");
        ScriptingManager scriptingManager = (ScriptingManager)this.manager(0).getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        HotRodClientTestingUtil.loadScript("/wordCountStream_dist.js", scriptingManager, "wordCountStream_dist.js");
        ArrayList results = (ArrayList)cache.execute("wordCountStream_dist.js", new HashMap());
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertEquals((int)3202, (int)((Map)results.get(0)).size());
        AssertJUnit.assertEquals((int)3202, (int)((Map)results.get(1)).size());
        AssertJUnit.assertTrue((boolean)((Long)((Map)results.get(0)).get("macbeth")).equals(287L));
        AssertJUnit.assertTrue((boolean)((Long)((Map)results.get(1)).get("macbeth")).equals(287L));
    }

    @Test(dataProvider="CacheNameProvider")
    public void testExecPutConstantGet(String cacheName) throws IOException {
        HotRodClientTestingUtil.withScript(this.manager(0), "/test-put-constant-get.js", scriptName -> {
            HashMap params = new HashMap();
            String result = (String)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute(scriptName, params);
            AssertJUnit.assertEquals((String)"hoptimus prime", (String)result);
            AssertJUnit.assertEquals((Object)"hoptimus prime", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"a"));
        });
    }

    @Test(dataProvider="CacheNameProvider")
    public void testExecReturnNull(String cacheName) throws IOException {
        HotRodClientTestingUtil.withScript(this.manager(0), "/test-null-return.js", scriptName -> {
            Object result = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals(null, (Object)result);
        });
    }

    @Test(dataProvider="CacheNameProvider")
    public void testLocalExecPutGet(String cacheName) {
        this.execPutGet(cacheName, "/test-put-get.js", ExecMode.LOCAL, "local-key", "local-value");
    }

    @Test(dataProvider="CacheNameProvider")
    public void testDistExecPutGet(String cacheName) {
        this.execPutGet(cacheName, "/test-put-get-dist.js", ExecMode.DIST, "dist-key", "dist-value");
    }

    @Test(dataProvider="CacheNameProvider")
    public void testLocalExecPutGetWithListener(String cacheName) {
        EventLogListener l = new EventLogListener(((RemoteCacheManager)this.clients.get(0)).getCache(cacheName));
        HotRodClientTestingUtil.withClientListener(l, remote -> HotRodClientTestingUtil.withScript(this.manager(0), "/test-put-get.js", scriptName -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("k", "local-key-listen");
            params.put("v", "local-value-listen");
            String result = (String)remote.execute(scriptName, params);
            l.expectOnlyCreatedEvent("local-key-listen");
            AssertJUnit.assertEquals((String)"local-value-listen", (String)result);
        }));
    }

    private void execPutGet(String cacheName, String path, ExecMode mode, String key, String value) {
        HotRodClientTestingUtil.withScript(this.manager(0), path, scriptName -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("k", key);
            params.put("v", value);
            params.put("cacheName", cacheName);
            Object results = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute(scriptName, params);
            mode.assertResult.accept(value, results);
        });
    }

    @DataProvider(name="CacheNameProvider")
    private static Object[][] provideCacheMode() {
        return new Object[][]{{REPL_CACHE}, {DIST_CACHE}};
    }

    static enum ExecMode {
        LOCAL(AssertJUnit::assertEquals),
        DIST((v, r) -> AssertJUnit.assertEquals(Arrays.asList(v, v), (Object)r));

        final BiConsumer<String, Object> assertResult;

        private ExecMode(BiConsumer<String, Object> assertResult) {
            this.assertResult = assertResult;
        }
    }
}

