/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.RemoteCacheManagerExtendedTest", groups={"functional"})
public class RemoteCacheManagerExtendedTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    int port;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = null;
    }

    @AfterTest
    public void release() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
    }

    public void testGetUndefinedCache() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.port);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build(), false);
        assert (!this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
        assert (null == this.remoteCacheManager.getCache("Undefined1234"));
    }

    public void testMarshallerInstance() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.port);
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        builder.marshaller((Marshaller)marshaller);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        AssertJUnit.assertTrue((marshaller == this.remoteCacheManager.getMarshaller() ? 1 : 0) != 0);
    }
}

