/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.AbstractAuthenticationTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SecureExecTest", groups={"functional"})
@CleanupAfterMethod
public class SecureExecTest
extends AbstractAuthenticationTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final String CACHE_NAME = "secured-exec";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        globalRoles.role("admin").permission(AuthorizationPermission.ALL).role("RWEuser").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.EXEC).role("RWuser").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        org.infinispan.configuration.cache.ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        config.security().authorization().enable().role("admin").role("RWEuser").role("RWuser");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (org.infinispan.configuration.cache.ConfigurationBuilder)config);
        this.cacheManager.defineConfiguration(CACHE_NAME, config.build());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    @Override
    protected SimpleServerAuthenticationProvider createAuthenticationProvider() {
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        sap.addUser("RWEuser", "realm", "password".toCharArray(), null);
        sap.addUser("RWuser", "realm", "password".toCharArray(), null);
        return sap;
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, () -> {
            SecureExecTest.super.setup();
            return null;
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> {
            SecureExecTest.super.teardown();
            return null;
        });
    }

    protected void clearContent() {
        this.cacheManager.getCache().clear();
    }

    @Override
    protected ConfigurationBuilder initServerAndClient() {
        return (ConfigurationBuilder)Security.doAs((Subject)ADMIN, () -> SecureExecTest.super.initServerAndClient());
    }

    public void testSimpleScriptExecutionWithValidAuth() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWEuser", "realm", "password".toCharArray()));
        this.runTestWithGivenScript(clientBuilder.build(), "/testRole_hotrod.js");
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unauthorized access.*")
    public void testSimpleScriptExecutionWithInvalidAuth() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWEuser", "realm", "password".toCharArray()));
        this.runTestWithGivenScript(clientBuilder.build(), "/testRole.js");
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unauthorized access.*")
    public void testSimpleScriptExecutionWithoutExecPerm() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWuser", "realm", "password".toCharArray()));
        this.runTestWithGivenScript(clientBuilder.build(), "/testWithoutRole.js");
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unauthorized access.*")
    public void testUploadWithoutScriptManagerRole() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWEuser", "realm", "password".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCacheManager.getCache("___script_cache").put((Object)"shouldFail", (Object)"1+1");
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unauthorized access.*")
    public void testClearWithoutScriptManagerRole() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("RWEuser", "realm", "password".toCharArray()));
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCacheManager.getCache("___script_cache").clear();
    }

    private void runTestWithGivenScript(Configuration config, String scriptPath) throws IOException, PrivilegedActionException {
        this.remoteCacheManager = new RemoteCacheManager(config);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "guinness");
        String scriptName = null;
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(scriptPath);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptName = scriptPath.substring(1);
            this.uploadScript(scriptName, script);
        }
        String result = (String)this.remoteCacheManager.getCache(CACHE_NAME).execute(scriptName, params);
        AssertJUnit.assertEquals((String)"guinness", (String)result);
        AssertJUnit.assertEquals((Object)"guinness", (Object)this.remoteCacheManager.getCache(CACHE_NAME).get((Object)"a"));
    }

    protected void uploadScript(final String scriptName, final String script) throws PrivilegedActionException {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecureExecTest.this.cacheManager.getCache("___script_cache").put((Object)scriptName, (Object)script);
                return null;
            }
        });
    }
}

