/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ServerShutdownTest", groups={"functional"})
public class ServerShutdownTest
extends AbstractInfinispanTest {
    public void testServerShutdownWithConnectedClient() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration())){

            public void call() {
                HotRodServer hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cm);
                try {
                    ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
                    clientBuilder.addServer().host("localhost").port(hotrodServer.getPort());
                    HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(clientBuilder.build())){

                        @Override
                        public void call() {
                            RemoteCache remoteCache = this.rcm.getCache();
                            remoteCache.put((Object)"k", (Object)"v");
                            AssertJUnit.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
                        }
                    });
                }
                catch (Throwable throwable) {
                    HotRodClientTestingUtil.killServers(hotrodServer);
                    throw throwable;
                }
                HotRodClientTestingUtil.killServers(hotrodServer);
            }
        });
    }

    public void testServerShutdownWithoutConnectedClient() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration())){

            public void call() {
                HotRodServer hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cm);
                try {
                    ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
                    clientBuilder.addServer().host("localhost").port(hotrodServer.getPort());
                    HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(clientBuilder.build())){

                        @Override
                        public void call() {
                            RemoteCache remoteCache = this.rcm.getCache();
                            remoteCache.put((Object)"k", (Object)"v");
                            AssertJUnit.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
                        }
                    });
                }
                catch (Throwable throwable) {
                    HotRodClientTestingUtil.killServers(hotrodServer);
                    throw throwable;
                }
                HotRodClientTestingUtil.killServers(hotrodServer);
            }
        });
    }
}

