/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.counter.AbstractCounterTest;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.counter.CounterManagerTestStrategy;
import org.infinispan.server.hotrod.counter.impl.CounterManagerImplTestStrategy;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.counter.RemoteCounterManagerTest")
public class RemoteCounterManagerTest
extends AbstractCounterTest
implements CounterManagerTestStrategy {
    private static final String PERSISTENT_LOCATION = TestingUtil.tmpDirectory((String)"RemoteCounterManagerTest");
    private static final String TMP_LOCATION = PERSISTENT_LOCATION + File.separator + "tmp";
    private final CounterManagerTestStrategy strategy = new CounterManagerImplTestStrategy(this::allTestCounterManagers, this::log, this::cacheManager);

    @BeforeClass
    public void cleanup() {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
    }

    public void testWeakCounter(Method method) {
        this.strategy.testWeakCounter(method);
    }

    public void testUnboundedStrongCounter(Method method) {
        this.strategy.testUnboundedStrongCounter(method);
    }

    public void testUpperBoundedStrongCounter(Method method) {
        this.strategy.testUpperBoundedStrongCounter(method);
    }

    public void testLowerBoundedStrongCounter(Method method) {
        this.strategy.testLowerBoundedStrongCounter(method);
    }

    public void testBoundedStrongCounter(Method method) {
        this.strategy.testBoundedStrongCounter(method);
    }

    public void testUndefinedCounter() {
        this.strategy.testUndefinedCounter();
    }

    public void testRemove(Method method) {
        this.strategy.testRemove(method);
    }

    public void testGetCounterNames(Method method) {
        this.strategy.testGetCounterNames(method);
    }

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        char id = 'A';
        id = (char)(id + this.cacheManagers.size());
        builder.globalState().enable().persistentLocation(PERSISTENT_LOCATION + File.separator + id).temporaryLocation(TMP_LOCATION);
    }

    private Log log() {
        return this.log;
    }

    private List<CounterManager> allTestCounterManagers() {
        return this.clients.stream().map(RemoteCounterManagerFactory::asCounterManager).collect(Collectors.toList());
    }

    private EmbeddedCacheManager cacheManager() {
        return this.manager(0);
    }
}

