/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientFilterEventsTest")
public class ClientFilterEventsTest
extends SingleHotRodServerTest {
    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory(2));
        server.addCacheEventFilterFactory("dynamic-filter-factory", (CacheEventFilterFactory)new EventLogListener.DynamicCacheEventFilterFactory());
        server.addCacheEventFilterFactory("raw-static-filter-factory", (CacheEventFilterFactory)new EventLogListener.RawStaticCacheEventFilterFactory());
        return server;
    }

    public void testFilteredEvents() {
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            l.expectOnlyCreatedEvent(2);
            remote.remove((Object)1);
            l.expectNoEvents();
            remote.remove((Object)2);
            l.expectOnlyRemovedEvent(2);
        });
    }

    public void testParameterBasedFiltering() {
        EventLogListener.DynamicFilteredEventLogListener l = new EventLogListener.DynamicFilteredEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, new Object[]{3}, null, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            l.expectNoEvents();
            remote.put((Object)3, (Object)"three");
            l.expectOnlyCreatedEvent(3);
        });
    }

    public void testFilteredEventsReplay() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        EventLogListener.StaticFilteredEventLogWithStateListener staticEventListener = new EventLogListener.StaticFilteredEventLogWithStateListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(staticEventListener, remote -> {
            staticEventListener.expectOnlyCreatedEvent(2);
            remote.remove((Object)1);
            remote.remove((Object)2);
            staticEventListener.expectOnlyRemovedEvent(2);
        });
        EventLogListener.DynamicFilteredEventLogWithStateListener dynamicEventListener = new EventLogListener.DynamicFilteredEventLogWithStateListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        cache.put((Object)3, (Object)"three");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, new Object[]{3}, null, remote -> {
            dynamicEventListener.expectOnlyCreatedEvent(3);
            remote.remove((Object)1);
            remote.remove((Object)2);
            remote.remove((Object)3);
            dynamicEventListener.expectOnlyRemovedEvent(3);
        });
    }

    public void testFilteredNoEventsReplay() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        EventLogListener.StaticFilteredEventLogListener staticEventListener = new EventLogListener.StaticFilteredEventLogListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        HotRodClientTestingUtil.withClientListener(staticEventListener, remote -> {
            staticEventListener.expectNoEvents();
            remote.remove((Object)1);
            remote.remove((Object)2);
            staticEventListener.expectOnlyRemovedEvent(2);
        });
        EventLogListener.DynamicFilteredEventLogListener dynamicEventListener = new EventLogListener.DynamicFilteredEventLogListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        cache.put((Object)3, (Object)"three");
        HotRodClientTestingUtil.withClientListener(dynamicEventListener, new Object[]{3}, null, remote -> {
            staticEventListener.expectNoEvents();
            remote.remove((Object)1);
            remote.remove((Object)2);
            remote.remove((Object)3);
            dynamicEventListener.expectOnlyRemovedEvent(3);
        });
    }

    @Test(expectedExceptions={HotRodClientException.class})
    public void testNonExistingConverterFactoryCustomEvents() {
        NonExistingFilterFactoryListener l = new NonExistingFilterFactoryListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {});
    }

    public void testRawFilteredEvents() {
        EventLogListener.RawStaticFilteredEventLogListener l = new EventLogListener.RawStaticFilteredEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            l.expectOnlyCreatedEvent(2);
            remote.remove((Object)1);
            l.expectNoEvents();
            remote.remove((Object)2);
            l.expectOnlyRemovedEvent(2);
        });
    }

    @ClientListener(filterFactoryName="non-existing-test-filter-factory")
    public static class NonExistingFilterFactoryListener<K>
    extends CustomEventLogListener<K, Object> {
        public NonExistingFilterFactoryListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }
}

