/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.RemoteCacheSupplier;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.LogFactory;

public class HotRodClientTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(HotRodClientTestingUtil.class, Log.class);

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager, HotRodServerConfigurationBuilder builder) {
        return HotRodClientTestingUtil.startHotRodServer(cacheManager, ServerTestingUtil.findFreePort(), builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager, int port, HotRodServerConfigurationBuilder builder) {
        return (HotRodServer)ServerTestingUtil.startProtocolServer((int)port, p -> HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, (int)p, (HotRodServerConfigurationBuilder)builder));
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager) {
        return HotRodClientTestingUtil.startHotRodServer(cacheManager, new HotRodServerConfigurationBuilder());
    }

    public static void killRemoteCacheManager(RemoteCacheManager rcm) {
        try {
            if (rcm != null) {
                rcm.stop();
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping remote cache manager", t);
        }
    }

    public static void killRemoteCacheManagers(RemoteCacheManager ... rcms) {
        if (rcms != null) {
            for (RemoteCacheManager rcm : rcms) {
                try {
                    if (rcm == null) continue;
                    rcm.stop();
                }
                catch (Throwable t) {
                    log.warn((Object)"Error stopping remote cache manager", t);
                }
            }
        }
    }

    public static void killServers(HotRodServer ... servers) {
        if (servers != null) {
            for (HotRodServer server : servers) {
                try {
                    if (server == null) continue;
                    server.stop();
                }
                catch (Throwable t) {
                    log.warn((Object)"Error stopping Hot Rod server", t);
                }
            }
        }
    }

    public static void withRemoteCacheManager(RemoteCacheManagerCallable c) {
        try {
            c.call();
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(c.rcm);
        }
    }

    public static <K, V> void withClientListener(RemoteCacheSupplier<K> l, Consumer<RemoteCache<K, V>> cons) {
        l.get().addClientListener(l);
        try {
            cons.accept(l.get());
        }
        finally {
            l.get().removeClientListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void withClientListener(RemoteCacheSupplier<K> listener, Object[] fparams, Object[] cparams, Consumer<RemoteCache<K, V>> cons) {
        listener.get().addClientListener(listener, fparams, cparams);
        try {
            cons.accept(listener.get());
        }
        finally {
            listener.get().removeClientListener(listener);
        }
    }

    public static <K> long entryVersion(Cache<byte[], ?> cache, K key) {
        byte[] lookupKey;
        try {
            lookupKey = HotRodClientTestingUtil.toBytes(key);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        Metadata meta = cache.getAdvancedCache().getCacheEntry((Object)lookupKey).getMetadata();
        return ((NumericVersion)meta.version()).getVersion();
    }

    public static byte[] toBytes(Object key) {
        try {
            return new GenericJBossMarshaller().objectToByteBuffer(key);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getServersString(HotRodServer ... servers) {
        StringBuilder builder = new StringBuilder();
        for (HotRodServer server : servers) {
            builder.append("localhost").append(':').append(server.getPort()).append(";");
        }
        return builder.toString();
    }

    public static RemoteCacheManager getRemoteCacheManager(HotRodServer server) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(server.getHost()).port(server.getPort());
        return new InternalRemoteCacheManager(builder.build());
    }

    public static byte[] getKeyForServer(HotRodServer primaryOwner) {
        return HotRodClientTestingUtil.getKeyForServer(primaryOwner, null);
    }

    public static byte[] getKeyForServer(HotRodServer primaryOwner, String cacheName) {
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        Cache cache = cacheName != null ? primaryOwner.getCacheManager().getCache(cacheName) : primaryOwner.getCacheManager().getCache();
        Random r = new Random();
        byte[] dummy = new byte[8];
        int attemptsLeft = 1000;
        try {
            do {
                r.nextBytes(dummy);
            } while (!DistributionTestHelper.isFirstOwner((Cache)cache, (Object)marshaller.objectToByteBuffer((Object)dummy)) && --attemptsLeft >= 0);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + primaryOwner);
        }
        log.infof("Binary key %s hashes to [cluster=%s,hotrod=%s]", (Object)Util.printArray((byte[])dummy, (boolean)false), (Object)primaryOwner.getCacheManager().getAddress(), (Object)primaryOwner.getAddress());
        return dummy;
    }

    public static Integer getIntKeyForServer(HotRodServer primaryOwner) {
        return HotRodClientTestingUtil.getIntKeyForServer(primaryOwner, null);
    }

    public static Integer getIntKeyForServer(HotRodServer primaryOwner, String cacheName) {
        Integer dummyInt;
        byte[] dummy;
        Cache cache = cacheName != null ? primaryOwner.getCacheManager().getCache(cacheName) : primaryOwner.getCacheManager().getCache();
        Random r = new Random();
        int attemptsLeft = 1000;
        while (!DistributionTestHelper.isFirstOwner((Cache)cache, (Object)(dummy = HotRodClientTestingUtil.toBytes(dummyInt = Integer.valueOf(r.nextInt())))) && --attemptsLeft >= 0) {
        }
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + primaryOwner);
        }
        log.infof("Integer key %s hashes to [cluster=%s,hotrod=%s]", (Object)dummyInt, (Object)primaryOwner.getCacheManager().getAddress(), (Object)primaryOwner.getAddress());
        return dummyInt;
    }

    public static Integer getSplitIntKeyForServer(HotRodServer primaryOwner, HotRodServer binaryOwner, String cacheName) {
        byte[] dummy;
        Integer dummyInt;
        Cache cache = cacheName != null ? primaryOwner.getCacheManager().getCache(cacheName) : primaryOwner.getCacheManager().getCache();
        Cache binaryOwnerCache = cacheName != null ? binaryOwner.getCacheManager().getCache(cacheName) : binaryOwner.getCacheManager().getCache();
        Random r = new Random();
        int attemptsLeft = 1000;
        boolean primaryOwnerFound = false;
        boolean binaryOwnerFound = false;
        do {
            dummyInt = r.nextInt();
            dummy = HotRodClientTestingUtil.toBytes(dummyInt);
            primaryOwnerFound = DistributionTestHelper.isFirstOwner((Cache)cache, (Object)dummyInt);
            binaryOwnerFound = DistributionTestHelper.isFirstOwner((Cache)binaryOwnerCache, (Object)dummy);
        } while ((!primaryOwnerFound || !binaryOwnerFound) && --attemptsLeft >= 0);
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + primaryOwner);
        }
        log.infof("Integer key [pojo=%s,bytes=%s] hashes to [cluster=%s,hotrod=%s], but the binary version's owner is [cluster=%s,hotrod=%s]", new Object[]{Util.toHexString((byte[])dummy), dummyInt, primaryOwner.getCacheManager().getAddress(), primaryOwner.getAddress(), binaryOwner.getCacheManager().getAddress(), binaryOwner.getAddress()});
        return dummyInt;
    }

    public static <T extends FailoverRequestBalancingStrategy> T getLoadBalancer(RemoteCacheManager client) {
        ChannelFactory channelFactory = client instanceof InternalRemoteCacheManager ? ((InternalRemoteCacheManager)client).getChannelFactory() : (ChannelFactory)TestingUtil.extractField((Object)client, (String)"channelFactory");
        return (T)channelFactory.getBalancer(HotRodConstants.DEFAULT_CACHE_NAME_BYTES);
    }

    public static void findServerAndKill(RemoteCacheManager client, Collection<HotRodServer> servers, Collection<EmbeddedCacheManager> cacheManagers) {
        InetSocketAddress addr = (InetSocketAddress)HotRodClientTestingUtil.getLoadBalancer(client).nextServer(null);
        for (HotRodServer server : servers) {
            if (server.getPort() != addr.getPort()) continue;
            HotRodClientTestingUtil.killServers(server);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{server.getCacheManager()});
            cacheManagers.remove(server.getCacheManager());
            TestingUtil.blockUntilViewsReceived((int)50000, (boolean)false, cacheManagers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withScript(EmbeddedCacheManager cm, String scriptPath, Consumer<String> f) {
        ScriptingManager scriptingManager = (ScriptingManager)cm.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        String scriptName = scriptPath.replaceAll("\\/", "");
        try {
            HotRodClientTestingUtil.loadScript(scriptName, scriptingManager, scriptPath);
            f.accept(scriptName);
        }
        finally {
            scriptingManager.removeScript(scriptName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScript(String scriptName, ScriptingManager scriptingManager, String fileName) {
        try (InputStream is = HotRodClientTestingUtil.class.getResourceAsStream(fileName);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptingManager.addScript(scriptName, script);
            String string = scriptName;
            return string;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withScript(BasicCache<String, String> scriptCache, String scriptPath, Consumer<String> f) {
        String scriptName = scriptPath.replaceAll("\\/", "");
        try {
            HotRodClientTestingUtil.loadScript(scriptName, scriptCache, scriptPath);
            f.accept(scriptName);
        }
        finally {
            scriptCache.remove((Object)scriptName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScript(String scriptName, BasicCache<String, String> scriptCache, String fileName) {
        try (InputStream is = HotRodClientTestingUtil.class.getResourceAsStream(fileName);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptCache.put((Object)scriptName, (Object)script);
            String string = scriptName;
            return string;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

