/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.xsite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;

abstract class AbstractHotRodSiteFailoverTest
extends AbstractXSiteTest {
    static String SITE_A = "LON";
    static String SITE_B = "NYC";
    static int NODES_PER_SITE = 2;
    Map<String, List<HotRodServer>> siteServers = new HashMap<String, List<HotRodServer>>();

    AbstractHotRodSiteFailoverTest() {
    }

    RemoteCacheManager client(String siteName, Optional<String> backupSiteName) {
        HotRodServer server = this.siteServers.get(siteName).get(0);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(server.getPort()).maxRetries(3);
        Optional<Integer> backupPort = backupSiteName.map(name -> {
            HotRodServer backupServer = this.siteServers.get(name).get(0);
            clientBuilder.addCluster(name).addClusterNode("localhost", backupServer.getPort());
            return backupServer.getPort();
        });
        if (backupPort.isPresent()) {
            this.log.debugf("Client for site '%s' connecting to main server in port %d, and backup cluster node port is %d", (Object)siteName, (Object)server.getPort(), (Object)backupPort.get());
        } else {
            this.log.debugf("Client for site '%s' connecting to main server in port %d", (Object)siteName, (Object)server.getPort());
        }
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    int findServerPort(String siteName) {
        return this.siteServers.get(siteName).get(0).getPort();
    }

    void killSite(String siteName) {
        this.log.debugf("Kill site '%s' with ports: %s", (Object)siteName, (Object)this.siteServers.get(siteName).stream().map(s -> String.valueOf(s.getPort())).collect(Collectors.joining(", ")));
        this.siteServers.get(siteName).forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0));
        this.site(siteName).cacheManagers().forEach(xva$0 -> TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{xva$0}));
    }

    protected void createSites() {
        this.createHotRodSite(SITE_A, SITE_B, Optional.empty());
        this.createHotRodSite(SITE_B, SITE_A, Optional.empty());
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            this.siteServers.values().forEach(servers -> servers.forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0)));
        }
        finally {
            super.destroy();
        }
    }

    protected void createHotRodSite(String siteName, String backupSiteName, Optional<Integer> serverPort) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)AbstractHotRodSiteFailoverTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        BackupConfigurationBuilder backup = builder.sites().addBackup();
        backup.site(backupSiteName).strategy(BackupConfiguration.BackupStrategy.SYNC);
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.site().localSite(siteName);
        AbstractXSiteTest.TestSite site = this.createSite(siteName, NODES_PER_SITE, globalBuilder, builder);
        List cacheManagers = site.cacheManagers();
        List servers = cacheManagers.stream().map(cm -> serverPort.map(port -> HotRodClientTestingUtil.startHotRodServer(cm, port, new HotRodServerConfigurationBuilder())).orElseGet(() -> HotRodClientTestingUtil.startHotRodServer(cm))).collect(Collectors.toList());
        this.siteServers.put(siteName, servers);
        this.log.debugf("Create site '%s' with ports: %s", (Object)siteName, (Object)servers.stream().map(s -> String.valueOf(s.getPort())).collect(Collectors.joining(", ")));
    }

    protected void addHitCountInterceptors() {
        this.siteServers.forEach((name, servers) -> servers.forEach(server -> {
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = new HitsAwareCacheManagersTest.HitCountInterceptor();
            server.getCacheManager().getCache().getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)interceptor, 1);
        }));
    }

    protected void assertNoHits() {
        this.siteServers.forEach((name, servers) -> servers.forEach(server -> {
            Cache cache = server.getCacheManager().getCache();
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.getHitCountInterceptor(cache);
            AssertJUnit.assertEquals((int)0, (int)interceptor.getHits());
        }));
    }

    protected void resetHitCounters() {
        this.siteServers.forEach((name, servers) -> servers.forEach(server -> {
            Cache cache = server.getCacheManager().getCache();
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.getHitCountInterceptor(cache);
            interceptor.reset();
        }));
    }

    protected void assertSiteHit(String siteName, int expectedHits) {
        Stream<HotRodServer> serversHit = this.siteServers.get(siteName).stream().filter(server -> {
            Cache cache = server.getCacheManager().getCache();
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.getHitCountInterceptor(cache);
            return interceptor.getHits() == expectedHits;
        });
        AssertJUnit.assertEquals((long)1L, (long)serversHit.count());
        this.resetHitCounters();
    }

    protected void assertSiteNotHit(String siteName) {
        this.siteServers.get(siteName).forEach(server -> {
            Cache cache = server.getCacheManager().getCache();
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.getHitCountInterceptor(cache);
            AssertJUnit.assertEquals((int)0, (int)interceptor.getHits());
        });
    }

    protected HitsAwareCacheManagersTest.HitCountInterceptor getHitCountInterceptor(Cache<?, ?> cache) {
        return (HitsAwareCacheManagersTest.HitCountInterceptor)cache.getAdvancedCache().getAsyncInterceptorChain().findInterceptorWithClass(HitsAwareCacheManagersTest.HitCountInterceptor.class);
    }
}

