/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class AuthOperation
extends HotRodOperation<byte[]> {
    private static final Log log = LogFactory.getLog(AuthOperation.class);
    private final Channel channel;
    private final String saslMechanism;
    private final byte[] response;

    public AuthOperation(Codec codec, AtomicInteger topologyId, Configuration cfg, Channel channel, ChannelFactory channelFactory, String saslMechanism, byte[] response) {
        super(codec, 0, cfg, DEFAULT_CACHE_NAME_BYTES, topologyId, channelFactory);
        this.channel = channel;
        this.saslMechanism = saslMechanism;
        this.response = response;
    }

    @Override
    public CompletableFuture<byte[]> execute() {
        if (!this.channel.isActive()) {
            throw log.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        byte[] saslMechBytes = this.saslMechanism.getBytes(HOTROD_STRING_CHARSET);
        HeaderParams header = this.headerParams((short)35);
        this.scheduleRead(this.channel, header);
        ByteBuf buf = this.channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateArraySize(saslMechBytes) + ByteBufUtil.estimateArraySize(this.response));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeArray(buf, saslMechBytes);
        ByteBufUtil.writeArray(buf, this.response);
        this.channel.writeAndFlush((Object)buf);
        return this;
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public byte[] decodePayload(ByteBuf buf, short status) {
        boolean complete = buf.readUnsignedByte() > 0;
        byte[] challenge = ByteBufUtil.readArray(buf);
        return complete ? null : challenge;
    }
}

