/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

@Immutable
public class GetAllOperation<K, V>
extends RetryOnFailureOperation<Map<K, V>> {
    private HeaderDecoder<Map<K, V>> decoder;
    private Map<K, V> result;
    private int size = -1;
    protected final Set<byte[]> keys;

    public GetAllOperation(Codec codec, ChannelFactory channelFactory, Set<byte[]> keys, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.keys = keys;
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)47);
        this.decoder = this.scheduleRead(channel, header);
        int bufSize = this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateVIntSize(this.keys.size());
        for (byte[] key : this.keys) {
            bufSize += ByteBufUtil.estimateArraySize(key);
        }
        ByteBuf buf = channel.alloc().buffer(bufSize);
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeVInt(buf, this.keys.size());
        for (byte[] key : this.keys) {
            ByteBufUtil.writeArray(buf, key);
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void reset() {
        this.result = null;
        this.size = -1;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.channelFactory.fetchChannelAndInvoke(this.keys.iterator().next(), failedServers, this.cacheName, this);
    }

    @Override
    public Map<K, V> decodePayload(ByteBuf buf, short status) {
        if (this.size < 0) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = new HashMap(this.size);
            this.decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object key = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
            Object value = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
            this.result.put(key, value);
            this.decoder.checkpoint();
        }
        return this.result;
    }
}

