/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelInboundHandlerDefaults;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class HotRodOperation<T>
extends CompletableFuture<T>
implements HotRodConstants,
ChannelInboundHandlerDefaults {
    private static final Log log = LogFactory.getLog(HotRodOperation.class);
    public final byte[] cacheName;
    protected final int flags;
    protected final AtomicInteger topologyId;
    protected final Codec codec;
    protected final Configuration cfg;
    protected final ChannelFactory channelFactory;
    private static final byte NO_TX = 0;
    private static final byte XA_TX = 1;

    protected HotRodOperation(Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicInteger topologyId, ChannelFactory channelFactory) {
        this.flags = flags;
        this.cfg = cfg;
        this.cacheName = cacheName;
        this.topologyId = topologyId;
        this.codec = codec;
        this.channelFactory = channelFactory;
    }

    public abstract CompletableFuture<T> execute();

    protected final HeaderParams headerParams(short operationCode) {
        return this.createHeader().opCode(operationCode).cacheName(this.cacheName).flags(this.flags).clientIntel(this.cfg.clientIntelligence()).topologyId(this.topologyId).txMarker((byte)0).topologyAge(this.channelFactory.getTopologyAge());
    }

    protected void sendHeaderAndRead(Channel channel, byte operationCode) {
        HeaderParams header = this.headerParams(operationCode);
        this.scheduleRead(channel, header);
        this.sendHeader(channel, header);
    }

    protected HeaderParams createHeader() {
        return new HeaderParams();
    }

    protected void sendHeader(Channel channel, HeaderParams header) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header));
        this.codec.writeHeader(buf, header);
        channel.writeAndFlush((Object)buf);
    }

    protected HeaderDecoder<T> scheduleRead(Channel channel, HeaderParams header) {
        HeaderDecoder decoder = new HeaderDecoder(this.codec, header, this.channelFactory, this);
        channel.pipeline().addLast(new ChannelHandler[]{decoder, this});
        return decoder;
    }

    public void releaseChannel(Channel channel) {
        this.channelFactory.releaseChannel(channel);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress address = ctx.channel().remoteAddress();
        this.completeExceptionally(log.connectionClosed(address, address));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.close();
        }
        finally {
            while (cause instanceof DecoderException && cause.getCause() != null) {
                cause = cause.getCause();
            }
            this.completeExceptionally(cause);
        }
    }

    protected void sendArrayOperation(Channel channel, HeaderParams header, byte[] array) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateArraySize(array));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeArray(buf, array);
        channel.writeAndFlush((Object)buf);
    }

    public abstract T decodePayload(ByteBuf var1, short var2);

    @Override
    public String toString() {
        String cn = this.cacheName == null || this.cacheName.length == 0 ? "(default)" : new String(this.cacheName);
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('{').append(cn);
        this.addParams(sb);
        sb.append(", flags=").append(Integer.toHexString(this.flags)).append('}');
        return sb.toString();
    }

    protected void addParams(StringBuilder sb) {
    }
}

