/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

@Immutable
public class PutAllOperation
extends RetryOnFailureOperation<Void> {
    protected final Map<byte[], byte[]> map;
    protected final long lifespan;
    private final TimeUnit lifespanTimeUnit;
    protected final long maxIdle;
    private final TimeUnit maxIdleTimeUnit;

    public PutAllOperation(Codec codec, ChannelFactory channelFactory, Map<byte[], byte[]> map, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.map = map;
        this.lifespan = lifespan;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdle = maxIdle;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)45);
        this.scheduleRead(channel, header);
        int bufSize = this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateVIntSize(this.map.size()) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            bufSize += ByteBufUtil.estimateArraySize(entry.getKey());
            bufSize += ByteBufUtil.estimateArraySize(entry.getValue());
        }
        ByteBuf buf = channel.alloc().buffer(bufSize);
        this.codec.writeHeader(buf, header);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeVInt(buf, this.map.size());
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            ByteBufUtil.writeArray(buf, entry.getKey());
            ByteBufUtil.writeArray(buf, entry.getValue());
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.channelFactory.fetchChannelAndInvoke(this.map.keySet().iterator().next(), failedServers, this.cacheName, this);
    }

    @Override
    public Void decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isSuccess(status)) {
            return null;
        }
        throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
    }
}

