/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class ReplaceIfUnmodifiedOperation
extends AbstractKeyValueOperation<VersionedOperationResponse> {
    private final long version;

    public ReplaceIfUnmodifiedOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        super(codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
        this.version = version;
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)9);
        this.scheduleRead(channel, header);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateArraySize(this.keyBytes) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + 8 + ByteBufUtil.estimateArraySize(this.value));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        buf.writeLong(this.version);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public VersionedOperationResponse decodePayload(ByteBuf buf, short status) {
        return this.returnVersionedOperationResponse(buf, status);
    }
}

