/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;
import org.infinispan.commons.util.Either;

public class HeaderOrEventDecoder<T>
extends HintedReplayingDecoder<Void> {
    private final Codec codec;
    private final HeaderParams params;
    private final ChannelFactory channelFactory;
    private final HotRodOperation<T> operation;
    private final Consumer<ClientEvent> eventConsumer;
    private final byte[] listenerId;
    private final Configuration configuration;

    public HeaderOrEventDecoder(Codec codec, HeaderParams params, ChannelFactory channelFactory, HotRodOperation<T> operation, Consumer<ClientEvent> eventConsumer, byte[] listenerId, Configuration configuration) {
        this.codec = codec;
        this.params = params;
        this.channelFactory = channelFactory;
        this.operation = operation;
        this.eventConsumer = eventConsumer;
        this.listenerId = listenerId;
        this.configuration = configuration;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Either<Short, ClientEvent> either = this.codec.readHeaderOrEvent(in, this.params, this.listenerId, this.channelFactory.getMarshaller(), this.configuration.serialWhitelist(), this.channelFactory, ctx.channel().remoteAddress());
        switch (either.type()) {
            case LEFT: {
                T result = this.operation.decodePayload(in, (Short)either.left());
                try {
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.pipeline().remove(this.operation);
                    this.operation.releaseChannel(ctx.channel());
                }
                catch (Throwable t) {
                    try {
                        ctx.channel().close();
                    }
                    catch (Throwable t2) {
                        t.addSuppressed(t2);
                    }
                    this.operation.completeExceptionally(t);
                    return;
                }
                this.operation.complete(result);
                break;
            }
            case RIGHT: {
                this.eventConsumer.accept((ClientEvent)either.right());
            }
        }
    }
}

