/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class AddListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;
    private Channel channel;

    public AddListenerOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, byte[] listenerId, SocketAddress server) {
        super(codec, channelFactory, topologyId, cfg, counterName);
        this.listenerId = listenerId;
        this.server = server;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.channel = channel;
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, (short)90, ByteBufUtil.estimateArraySize(this.listenerId));
        ByteBufUtil.writeArray(buf, this.listenerId);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public Boolean decodePayload(ByteBuf buf, short status) {
        this.checkStatus(status);
        if (status != 0) {
            this.channel = null;
            return false;
        }
        return true;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.server == null) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.channelFactory.fetchChannelAndInvoke(this.server, this);
        }
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.channel != channel) {
            super.releaseChannel(channel);
        }
    }
}

