/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.CacheTopologyInfoImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Immutables;

public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final WrappedByteArray EMPTY_BYTES = new WrappedByteArray(new byte[0]);
    private Map<WrappedByteArray, Collection<SocketAddress>> servers = new ConcurrentHashMap<WrappedByteArray, Collection<SocketAddress>>();
    private Map<WrappedByteArray, ConsistentHash> consistentHashes = new ConcurrentHashMap<WrappedByteArray, ConsistentHash>();
    private Map<WrappedByteArray, Integer> segmentsByCache = new ConcurrentHashMap<WrappedByteArray, Integer>();
    private Map<WrappedByteArray, AtomicInteger> topologyIds = new ConcurrentHashMap<WrappedByteArray, AtomicInteger>();
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();

    public TopologyInfo(AtomicInteger topologyId, Collection<SocketAddress> initialServers, Configuration configuration) {
        this.topologyIds.put(EMPTY_BYTES, topologyId);
        this.servers.put(EMPTY_BYTES, initialServers);
        this.hashFactory.init(configuration);
    }

    private Map<SocketAddress, Set<Integer>> getSegmentsByServer(byte[] cacheName) {
        WrappedByteArray key = new WrappedByteArray(cacheName);
        ConsistentHash consistentHash = this.consistentHashes.get(key);
        if (consistentHash != null) {
            return consistentHash.getSegmentsByServer();
        }
        Optional<Integer> numSegments = Optional.ofNullable(this.segmentsByCache.get(key));
        Optional<Set> segments = numSegments.map(n -> IntStream.range(0, n).boxed().collect(Collectors.toSet()));
        return Immutables.immutableMapWrap(this.servers.get(key).stream().collect(Collectors.toMap(Function.identity(), s -> segments.orElse(Collections.emptySet()))));
    }

    public Collection<SocketAddress> getServers(WrappedByteArray cacheName) {
        return this.servers.computeIfAbsent(cacheName, k -> this.servers.get(EMPTY_BYTES));
    }

    public Collection<SocketAddress> getServers() {
        return this.servers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void updateTopology(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace, byte[] cacheName, AtomicInteger topologyId) {
        Object hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
        if (hash == null) {
            log.noHasHFunctionConfigured(hashFunctionVersion);
        } else {
            hash.init(servers2Hash, numKeyOwners, hashSpace);
        }
        WrappedByteArray key = new WrappedByteArray(cacheName);
        this.consistentHashes.put(key, (ConsistentHash)hash);
        this.topologyIds.put(key, topologyId);
    }

    public void updateTopology(SocketAddress[][] segmentOwners, int numSegments, short hashFunctionVersion, byte[] cacheName, AtomicInteger topologyId) {
        WrappedByteArray key = new WrappedByteArray(cacheName);
        if (hashFunctionVersion > 0) {
            SegmentConsistentHash hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
            this.consistentHashes.put(key, hash);
        }
        this.segmentsByCache.put(key, numSegments);
        this.topologyIds.put(key, topologyId);
    }

    public Optional<SocketAddress> getHashAwareServer(Object key, byte[] cacheName) {
        Optional<SocketAddress> server = Optional.empty();
        if (this.isTopologyValid(cacheName)) {
            ConsistentHash consistentHash = this.consistentHashes.get(new WrappedByteArray(cacheName));
            if (consistentHash != null) {
                server = Optional.of(consistentHash.getServer(key));
                if (trace) {
                    log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
                }
            }
            return server;
        }
        return Optional.empty();
    }

    public boolean isTopologyValid(byte[] cacheName) {
        Integer id = this.topologyIds.get(new WrappedByteArray(cacheName)).get();
        Boolean valid = id != -2;
        if (trace) {
            log.tracef("Is topology id (%s) valid? %b", id, valid);
        }
        return valid;
    }

    public void updateServers(byte[] cacheName, Collection<SocketAddress> updatedServers) {
        WrappedByteArray wrappedCacheName = cacheName == null || cacheName.length == 0 ? EMPTY_BYTES : new WrappedByteArray(cacheName);
        this.servers.put(wrappedCacheName, updatedServers);
    }

    public ConsistentHash getConsistentHash(byte[] cacheName) {
        return this.consistentHashes.get(new WrappedByteArray(cacheName));
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public AtomicInteger createTopologyId(byte[] cacheName, int topologyId) {
        return this.topologyIds.computeIfAbsent(new WrappedByteArray(cacheName), c -> new AtomicInteger(topologyId));
    }

    public void setTopologyId(byte[] cacheName, int topologyId) {
        AtomicInteger id = this.topologyIds.get(new WrappedByteArray(cacheName));
        id.set(topologyId);
    }

    public void setAllTopologyIds(int newTopologyId) {
        for (AtomicInteger topologyId : this.topologyIds.values()) {
            topologyId.set(newTopologyId);
        }
    }

    public int getTopologyId(byte[] cacheName) {
        return this.topologyIds.get(new WrappedByteArray(cacheName)).get();
    }

    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        WrappedByteArray key = new WrappedByteArray(cacheName);
        return new CacheTopologyInfoImpl(this.getSegmentsByServer(cacheName), this.segmentsByCache.get(key), this.topologyIds.get(key).get());
    }
}

