/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.protocol.MultimapHeaderParams;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class ContainsValueMultimapOperation
extends RetryOnFailureOperation<Boolean> {
    protected final byte[] value;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;

    protected ContainsValueMultimapOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    protected HeaderParams createHeader() {
        return new MultimapHeaderParams();
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)119);
        this.scheduleRead(channel, header);
        this.sendValueOperation(channel, header);
    }

    @Override
    public Boolean decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isNotExist(status)) {
            return Boolean.FALSE;
        }
        return buf.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void sendValueOperation(Channel channel, HeaderParams header) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + ByteBufUtil.estimateArraySize(this.value));
        this.codec.writeHeader(buf, header);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }
}

