/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class BulkGetKeysOperation<K>
extends RetryOnFailureOperation<Set<K>> {
    private final int scope;
    private final Set<K> result = new HashSet<K>();
    private HeaderDecoder<Set<K>> decoder;

    public BulkGetKeysOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, int scope) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.scope = scope;
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)29);
        this.decoder = this.scheduleRead(channel, header);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateVIntSize(this.scope));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeVInt(buf, this.scope);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void reset() {
        this.result.clear();
    }

    @Override
    public Set<K> decodePayload(ByteBuf buf, short status) {
        while (buf.readUnsignedByte() == 1) {
            this.result.add(this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller()));
            this.decoder.checkpoint();
        }
        return this.result;
    }
}

