/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class BulkGetOperation<K, V>
extends RetryOnFailureOperation<Map<K, V>> {
    private final int entryCount;
    private final Map<K, V> result = new HashMap();
    private HeaderDecoder<Map<K, V>> decoder;

    public BulkGetOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, int entryCount) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.entryCount = entryCount;
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)25);
        this.decoder = this.scheduleRead(channel, header);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateVIntSize(this.entryCount));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeVInt(buf, this.entryCount);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public Map<K, V> decodePayload(ByteBuf buf, short status) {
        while (buf.readUnsignedByte() == 1) {
            Object key = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
            Object value = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
            this.result.put(key, value);
            this.decoder.checkpoint();
        }
        return this.result;
    }
}

