/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.VersionedMetadataImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.ChannelInputStream;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

@Immutable
public class GetStreamOperation
extends AbstractKeyOperation<ChannelInputStream> {
    private final int offset;
    private Channel channel;

    public GetStreamOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, int offset, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg);
        this.offset = offset;
    }

    @Override
    public void executeOperation(Channel channel) {
        this.channel = channel;
        HeaderParams header = this.headerParams((short)55);
        this.scheduleRead(channel, header);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(header) + ByteBufUtil.estimateArraySize(this.keyBytes) + ByteBufUtil.estimateVIntSize(this.offset));
        this.codec.writeHeader(buf, header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        ByteBufUtil.writeVInt(buf, this.offset);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public ChannelInputStream decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status)) {
            super.releaseChannel(this.channel);
            return null;
        }
        short flags = buf.readUnsignedByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        long version = buf.readLong();
        int totalLength = ByteBufUtil.readVInt(buf);
        VersionedMetadataImpl versionedMetadata = new VersionedMetadataImpl(creation, lifespan, lastUsed, maxIdle, version);
        ChannelInputStream stream = new ChannelInputStream(versionedMetadata, () -> this.channelFactory.releaseChannel(this.channel), totalLength);
        this.channel.pipeline().addLast(new ChannelHandler[]{stream});
        return stream;
    }
}

