/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;

public class RemoveClientListenerOperation
extends HotRodOperation<Void>
implements ChannelOperation {
    private final ClientListenerNotifier listenerNotifier;
    private final Object listener;
    private byte[] listenerId;

    protected RemoveClientListenerOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener) {
        super(codec, flags, cfg, cacheName, topologyId, channelFactory);
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
    }

    protected void fetchChannelAndInvoke() {
        this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        if (this.listenerId != null) {
            SocketAddress address = this.listenerNotifier.findAddress(this.listenerId);
            this.channelFactory.fetchChannelAndInvoke(address, this);
        } else {
            this.complete(null);
        }
    }

    @Override
    public void invoke(Channel channel) {
        HeaderParams header = this.headerParams((short)39);
        this.scheduleRead(channel, header);
        this.sendArrayOperation(channel, header, this.listenerId);
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public Void decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isSuccess(status) || HotRodConstants.isNotExecuted(status)) {
            this.listenerNotifier.removeClientListener(this.listenerId);
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> execute() {
        this.fetchChannelAndInvoke();
        return this;
    }
}

