/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import org.infinispan.client.hotrod.impl.protocol.Codec11;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class Codec12
extends Codec11 {
    private static final Log log = LogFactory.getLog(Codec12.class, Log.class);

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)12);
    }

    @Override
    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, params.messageId((long)Codec12.MSG_ID.incrementAndGet()).messageId);
        buf.writeByte((int)version);
        buf.writeByte((int)params.opCode);
        ByteBufUtil.writeArray(buf, params.cacheName);
        int joinedFlags = params.flags;
        ByteBufUtil.writeVInt(buf, joinedFlags);
        buf.writeByte((int)params.clientIntel);
        ByteBufUtil.writeVInt(buf, params.topologyId.get());
        buf.writeByte((int)params.txMarker);
        this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, joinedFlags);
        return params;
    }

    @Override
    public Log getLog() {
        return log;
    }
}

