/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Signal;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;

public class HeaderDecoder<T>
extends HintedReplayingDecoder<State>
implements Runnable {
    private final Codec codec;
    private final HeaderParams headerParams;
    private final ChannelFactory channelFactory;
    private final HotRodOperation<T> operation;
    private short status;
    private volatile ScheduledFuture<?> timeoutFuture;

    public HeaderDecoder(Codec codec, HeaderParams headerParams, ChannelFactory channelFactory, HotRodOperation<T> operation) {
        super(State.READ_HEADER);
        this.codec = codec;
        this.headerParams = headerParams;
        this.channelFactory = channelFactory;
        this.operation = operation;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.timeoutFuture = ctx.executor().schedule((Runnable)this, (long)this.channelFactory.socketTimeout(), TimeUnit.MILLISECONDS);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case READ_HEADER: {
                try {
                    this.status = this.codec.readHeader(in, this.headerParams, this.channelFactory, ctx.channel().remoteAddress());
                }
                catch (Signal signal) {
                    throw signal;
                }
                catch (Throwable t) {
                    ctx.pipeline().remove((ChannelHandler)this);
                    throw t;
                }
                this.checkpoint(State.READ_PAYLOAD);
            }
            case READ_PAYLOAD: {
                T result = this.operation.decodePayload(in, this.status);
                try {
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.pipeline().remove(this.operation);
                    this.operation.releaseChannel(ctx.channel());
                    this.timeoutFuture.cancel(false);
                }
                catch (Throwable t) {
                    try {
                        ctx.channel().close();
                    }
                    catch (Throwable t2) {
                        t.addSuppressed(t2);
                    }
                    this.operation.completeExceptionally(t);
                    return;
                }
                this.operation.complete(result);
            }
        }
    }

    @Override
    public void checkpoint() {
        super.checkpoint();
    }

    @Override
    public void run() {
        this.operation.completeExceptionally(new SocketTimeoutException(this.operation + " timed out after " + this.channelFactory.socketTimeout() + " ms"));
    }

    static enum State {
        READ_HEADER,
        READ_PAYLOAD;

    }
}

