/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class IterationStartOperation
extends RetryOnFailureOperation<IterationStartResponse> {
    private final String filterConverterFactory;
    private final byte[][] filterParameters;
    private final Set<Integer> segments;
    private final int batchSize;
    private final ChannelFactory channelFactory;
    private final boolean metadata;
    private Channel channel;

    IterationStartOperation(Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicInteger topologyId, String filterConverterFactory, byte[][] filterParameters, Set<Integer> segments, int batchSize, ChannelFactory channelFactory, boolean metadata) {
        super((short)49, (short)50, codec, channelFactory, cacheName, topologyId, flags, cfg);
        this.filterConverterFactory = filterConverterFactory;
        this.filterParameters = filterParameters;
        this.segments = segments;
        this.batchSize = batchSize;
        this.channelFactory = channelFactory;
        this.metadata = metadata;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.channel = channel;
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        if (this.segments == null) {
            ByteBufUtil.writeSignedVInt(buf, -1);
        } else {
            BitSet bitSet = new BitSet();
            this.segments.stream().forEach(bitSet::set);
            ByteBufUtil.writeOptionalArray(buf, bitSet.toByteArray());
        }
        ByteBufUtil.writeOptionalString(buf, this.filterConverterFactory);
        if (this.filterConverterFactory != null) {
            if (this.filterParameters != null && this.filterParameters.length > 0) {
                buf.writeByte(this.filterParameters.length);
                Arrays.stream(this.filterParameters).forEach(param -> ByteBufUtil.writeArray(buf, param));
            } else {
                buf.writeByte(0);
            }
        }
        ByteBufUtil.writeVInt(buf, this.batchSize);
        buf.writeByte(this.metadata ? 1 : 0);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        SegmentConsistentHash consistentHash = (SegmentConsistentHash)this.channelFactory.getConsistentHash(this.cacheName);
        IterationStartResponse response = new IterationStartResponse(ByteBufUtil.readArray(buf), consistentHash, this.header.topologyId().get(), this.channel);
        this.complete(response);
    }
}

