/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterExpirationEventsTest")
public class ClientClusterExpirationEventsTest
extends MultiHotRodServersTest {
    static final int NUM_SERVERS = 2;
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
        this.injectTimeServices();
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = ClientClusterExpirationEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected HotRodServer addHotRodServer(ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        server.addCacheEventConverterFactory("static-converter-factory", new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventFilterConverterFactory("filter-converter-factory", (CacheEventFilterConverterFactory)new CustomEventLogListener.FilterConverterFactory());
        this.servers.add(server);
        return server;
    }

    private void injectTimeServices() {
        long now = System.currentTimeMillis();
        this.ts0 = new ControlledTimeService(now);
        TestingUtil.replaceComponent((CacheContainer)this.server(0).getCacheManager(), TimeService.class, (Object)this.ts0, (boolean)true);
        this.ts1 = new ControlledTimeService(now);
        TestingUtil.replaceComponent((CacheContainer)this.server(1).getCacheManager(), TimeService.class, (Object)this.ts1, (boolean)true);
    }

    public void testSimpleExpired() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        EventLogListener l = new EventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
            l.expectOnlyCreatedEvent(key0);
            this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
            AssertJUnit.assertNull((Object)remote.get((Object)key0));
            l.expectOnlyExpiredEvent(key0);
        });
    }

    public void testFilteringInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        for (HotRodServer server : this.servers) {
            server.addCacheEventFilterFactory("static-filter-factory", new EventLogListener.StaticCacheEventFilterFactory<Integer>(key1));
        }
        EventLogListener allEvents = new EventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(allEvents, r1 -> {
            EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(r1);
            HotRodClientTestingUtil.withClientListener(l, remote -> {
                allEvents.expectNoEvents();
                l.expectNoEvents();
                remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
                allEvents.expectOnlyCreatedEvent(key0);
                l.expectNoEvents();
                remote.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
                allEvents.expectOnlyCreatedEvent(key1);
                l.expectOnlyCreatedEvent(key1);
                this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                AssertJUnit.assertNull((Object)remote.get((Object)key0));
                allEvents.expectOnlyExpiredEvent(key0);
                l.expectNoEvents();
                AssertJUnit.assertNull((Object)remote.get((Object)key1));
                allEvents.expectOnlyExpiredEvent(key1);
                l.expectOnlyExpiredEvent(key1);
            });
        });
    }

    public void testConversionInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, "one", 0));
            remote.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 0));
            this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
            this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
            AssertJUnit.assertNull((Object)remote.get((Object)key0));
            l.expectExpiredEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, "one", 0));
            AssertJUnit.assertNull((Object)remote.get((Object)key1));
            l.expectExpiredEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 0));
        });
    }

    public void testFilterCustomEventsInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        CustomEventLogListener.FilterCustomEventLogListener l = new CustomEventLogListener.FilterCustomEventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, new Object[]{key0}, null, remote -> {
            remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 1));
            remote.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 1));
            this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
            this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
            AssertJUnit.assertNull((Object)remote.get((Object)key0));
            l.expectExpiredEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 2));
            AssertJUnit.assertNull((Object)remote.get((Object)key1));
            l.expectExpiredEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 2));
        });
    }

    public void testNullValueMetadataExpiration() {
        Integer key = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        EventLogListener l = new EventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            Cache cache0 = this.cache(0);
            CacheNotifier notifier = (CacheNotifier)cache0.getAdvancedCache().getComponentRegistry().getComponent(CacheNotifier.class);
            byte[] keyBytes = HotRodClientTestingUtil.toBytes(key);
            notifier.notifyCacheEntryExpired((Object)keyBytes, null, null, null);
            l.expectOnlyExpiredEvent(key);
        });
    }
}

