/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.ArrayList;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.ProtobufRemoteIteratorIndexingTest")
public class ProtobufRemoteIteratorIndexingTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    private static final int NUM_NODES = 2;
    private static final int CACHE_SIZE = 10;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = ProtobufRemoteIteratorIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cfg.indexing().index(Index.ALL).indexing().addProperty("default.directory_provider", "local-heap");
        this.createHotRodServers(2, HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)cfg));
        this.waitForClusterToForm();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testSimpleIteration() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, cache);
        ArrayList results = new ArrayList();
        cache.retrieveEntries(null, null, 10).forEachRemaining(e -> results.add((AccountPB)e.getValue()));
        Assert.assertEquals((int)10, (int)results.size());
    }

    public void testFilteredIterationWithQuery() {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, remoteCache);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        int lowerId = 5;
        int higherId = 8;
        Query simpleQuery = queryFactory.from(AccountPB.class).having("id").between((Object)lowerId, (Object)higherId).build();
        Set entries = this.extractEntries(remoteCache.retrieveEntriesByQuery(simpleQuery, null, 10));
        Set keys = this.extractKeys(entries);
        Assert.assertEquals((int)4, (int)keys.size());
        this.assertForAll(keys, key -> key >= lowerId && key <= higherId);
        this.assertForAll(entries, e -> e.getValue() instanceof AccountPB);
        Query projectionsQuery = queryFactory.from(AccountPB.class).select(new String[]{"id", "description"}).having("id").between((Object)lowerId, (Object)higherId).build();
        Set entriesWithProjection = this.extractEntries(remoteCache.retrieveEntriesByQuery(projectionsQuery, null, 10));
        Assert.assertEquals((int)4, (int)entriesWithProjection.size());
        this.assertForAll(entriesWithProjection, entry -> {
            Integer id = (Integer)entry.getKey();
            Object[] value = (Object[])entry.getValue();
            return value[0] == id && value[1].equals("description for " + id);
        });
    }
}

