/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.PrimitiveEmbeddedRemoteInteropTest", groups={"functional"})
public class PrimitiveEmbeddedRemoteInteropTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private Cache embeddedCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.createConfigBuilder();
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.embeddedCache = this.cache.getAdvancedCache().withEncoding(IdentityEncoder.class);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder createConfigBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.encoding().key().mediaType("application/x-java-object");
        builder.encoding().value().mediaType("application/x-java-object");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testRemotePutAndGet() {
        this.remotePutAndGet(1, "foo");
        this.remotePutAndGet(1, true);
        this.remotePutAndGet(1, 7);
        this.remotePutAndGet(1, 777L);
        this.remotePutAndGet(1, 0.0);
        this.remotePutAndGet(1, 1.0);
    }

    private void remotePutAndGet(Object key, Object value) {
        this.remoteCache.clear();
        this.remoteCache.put(key, value);
        Object remoteValue = this.remoteCache.get(key);
        AssertJUnit.assertEquals((Object)value, (Object)remoteValue);
        AssertJUnit.assertEquals((int)1, (int)this.embeddedCache.keySet().size());
        Object localKey = this.embeddedCache.keySet().iterator().next();
        AssertJUnit.assertEquals((Object)key, (Object)localKey);
        Object localObject = this.embeddedCache.get(localKey);
        AssertJUnit.assertEquals((Object)value, (Object)localObject);
    }

    public void testEmbeddedPutAndGet() {
        this.embeddedPutAndGet(1, "bar");
        this.embeddedPutAndGet(1, true);
        this.embeddedPutAndGet(1, 7);
        this.embeddedPutAndGet(1, 777L);
        this.embeddedPutAndGet(1, 0.0);
        this.embeddedPutAndGet(1, 1.0);
    }

    private void embeddedPutAndGet(Object key, Object value) {
        this.embeddedCache.clear();
        this.embeddedCache.put(key, value);
        AssertJUnit.assertTrue((boolean)this.embeddedCache.keySet().contains(key));
        Object localValue = this.embeddedCache.get(key);
        AssertJUnit.assertEquals((Object)value, (Object)localValue);
        AssertJUnit.assertEquals((int)1, (int)this.remoteCache.keySet().size());
        Object remoteKey = this.remoteCache.keySet().iterator().next();
        AssertJUnit.assertEquals((Object)key, (Object)remoteKey);
        Object remoteValue = this.remoteCache.get(remoteKey);
        AssertJUnit.assertEquals((Object)value, (Object)remoteValue);
    }
}

