/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.client.hotrod.query.RemoteQueryDslConditionsFilesystemTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.Search;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryDslConditionsTunedTest", groups={"functional"})
public class RemoteQueryDslConditionsTunedTest
extends RemoteQueryDslConditionsFilesystemTest {
    private static final int NUM_SHARDS = 6;

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addProperty("default.indexmanager", "near-real-time").addProperty("default.indexBase", this.indexDirectory).addProperty("default.exclusive_index_use", "true").addProperty("default.indexwriter.merge_factor", "30").addProperty("default.indexwriter.merge_max_size", "4096").addProperty("default.indexwriter.ram_buffer_size", "220").addProperty("default.locking_strategy", "native").addProperty("default.sharding_strategy.nbr_of_shards", String.valueOf(6));
        return builder;
    }

    @Override
    public void testIndexPresence() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)Search.getSearchManager(this.getEmbeddedCache()).unwrap(SearchIntegrator.class);
        AssertJUnit.assertTrue((boolean)searchIntegrator.getIndexBindings().containsKey(ProtobufValueWrapper.INDEXING_TYPE));
        for (int shard = 0; shard < 6; ++shard) {
            AssertJUnit.assertNotNull((Object)searchIntegrator.getIndexManager(ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName()) + '.' + shard));
        }
    }
}

