/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AnalyzerTestEntity;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.AnalyzerTestEntityMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.NotIndexedMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryStringTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryStringTest")
public class RemoteQueryStringTest
extends QueryStringTest {
    private static final String NOT_INDEXED_PROTO_SCHEMA = "package sample_bank_account;\n/* @Indexed(false) */\nmessage NotIndexed {\n\toptional string notIndexedField = 1;\n}\n";
    private static final String CUSTOM_ANALYZER_PROTO_SCHEMA = "package sample_bank_account;\n/* @Indexed \n   @Analyzer(definition = \"standard-with-stop\") */message AnalyzerTestEntity {\n\t/* @Field(store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"stemmer\")) */\n\toptional string f1 = 1;\n\t/* @Field(store = Store.YES, analyze = Analyze.NO, indexNullAs = \"-1\") */\n\toptional int32 f2 = 2;\n}\n";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    @BeforeClass
    protected void populateCache() throws Exception {
        super.populateCache();
        this.getCacheForWrite().put((Object)"analyzed1", (Object)new AnalyzerTestEntity("tested 123", 3));
        this.getCacheForWrite().put((Object)"analyzed2", (Object)new AnalyzerTestEntity("testing 1234", 3));
        this.getCacheForWrite().put((Object)"analyzed3", (Object)new AnalyzerTestEntity("xyz", null));
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected int getNodesCount() {
        return 1;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = this.getConfigurationBuilder();
        this.createClusteredCaches(this.getNodesCount(), cfg, true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.initProtoSchema(this.remoteCacheManager);
    }

    protected void initProtoSchema(RemoteCacheManager remoteCacheManager) throws IOException {
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        metadataCache.put((Object)"not_indexed.proto", (Object)NOT_INDEXED_PROTO_SCHEMA);
        metadataCache.put((Object)"custom_analyzer.proto", (Object)CUSTOM_ANALYZER_PROTO_SCHEMA);
        RemoteQueryTestUtils.checkSchemaErrors((RemoteCache<String, String>)metadataCache);
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        MarshallerRegistration.registerMarshallers(serCtx);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"not_indexed.proto", (String)NOT_INDEXED_PROTO_SCHEMA));
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"custom_analyzer.proto", (String)CUSTOM_ANALYZER_PROTO_SCHEMA));
        serCtx.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
        serCtx.registerMarshaller((BaseMarshaller)new AnalyzerTestEntityMarshaller());
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy.*")
    public void testFullTextWildcardFuzzyNotAllowed() {
        super.testFullTextWildcardFuzzyNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028526: Invalid query.*")
    public void testFullTextRegexpFuzzyNotAllowed() {
        super.testFullTextRegexpFuzzyNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028522: .*property is analyzed.*")
    public void testExactMatchOnAnalyzedFieldNotAllowed() {
        super.testExactMatchOnAnalyzedFieldNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028521: .*unless the property is indexed and analyzed.*")
    public void testFullTextTermOnNonAnalyzedFieldNotAllowed() {
        super.testFullTextTermOnNonAnalyzedFieldNotAllowed();
    }

    public void testInstant1() {
        Query q = this.createQueryFromString("from " + this.getModelFactory().getUserTypeName() + " u where u.creationDate = " + Instant.parse("2011-12-03T10:15:30Z").toEpochMilli());
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testInstant2() {
        Query q = this.createQueryFromString("from " + this.getModelFactory().getUserTypeName() + " u where u.passwordExpirationDate = " + Instant.parse("2011-12-03T10:15:30Z").toEpochMilli());
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testCustomFieldAnalyzer() {
        Query q = this.createQueryFromString("from sample_bank_account.AnalyzerTestEntity where f1:'test'");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testEqNonIndexedType() {
        Query q = this.createQueryFromString("from sample_bank_account.NotIndexed where notIndexedField = 'testing 123'");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }
}

