/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;

public final class DataFormat {
    private static final Log log = LogFactory.getLog(DataFormat.class, Log.class);
    private final MediaType keyType;
    private final MediaType valueType;
    private final Marshaller keyMarshaller;
    private final Marshaller valueMarshaller;
    private MarshallerRegistry marshallerRegistry;
    private Marshaller defaultMarshaller;
    private boolean isObjectStorage;

    private DataFormat(MediaType keyType, MediaType valueType, Marshaller keyMarshaller, Marshaller valueMarshaller) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyMarshaller = keyMarshaller;
        this.valueMarshaller = valueMarshaller;
    }

    public DataFormat withoutValueType() {
        return new DataFormat(this.keyType, null, this.keyMarshaller, null);
    }

    public MediaType getKeyType() {
        if (this.keyType != null) {
            return this.keyType;
        }
        Marshaller marshaller = this.resolveKeyMarshaller();
        return marshaller == null ? null : marshaller.mediaType();
    }

    public MediaType getValueType() {
        if (this.valueType != null) {
            return this.valueType;
        }
        Marshaller marshaller = this.resolveValueMarshaller();
        return marshaller == null ? null : marshaller.mediaType();
    }

    public void initialize(RemoteCacheManager remoteCacheManager, boolean serverObjectStorage) {
        this.marshallerRegistry = remoteCacheManager.getMarshallerRegistry();
        this.defaultMarshaller = remoteCacheManager.getMarshaller();
        this.isObjectStorage = serverObjectStorage;
    }

    private Marshaller resolveValueMarshaller() {
        if (this.valueMarshaller != null) {
            return this.valueMarshaller;
        }
        if (this.valueType == null) {
            return this.defaultMarshaller;
        }
        Marshaller forValueType = this.marshallerRegistry.getMarshaller(this.valueType);
        if (forValueType != null) {
            return forValueType;
        }
        log.debugf("No marshaller registered for %s, using no-op marshaller", this.valueType);
        return IdentityMarshaller.INSTANCE;
    }

    public boolean isObjectStorage() {
        return this.isObjectStorage;
    }

    private Marshaller resolveKeyMarshaller() {
        if (this.keyMarshaller != null) {
            return this.keyMarshaller;
        }
        if (this.keyType == null) {
            return this.defaultMarshaller;
        }
        Marshaller forKeyType = this.marshallerRegistry.getMarshaller(this.keyType);
        if (forKeyType != null) {
            return forKeyType;
        }
        log.debugf("No marshaller registered for %s, using no-op marshaller", this.keyType);
        return IdentityMarshaller.INSTANCE;
    }

    public byte[] keyToBytes(Object key, int estimateKeySize, int estimateValueSize) {
        Marshaller keyMarshaller = this.resolveKeyMarshaller();
        return MarshallerUtil.obj2bytes(keyMarshaller, key, true, estimateKeySize, estimateValueSize);
    }

    public byte[] valueToBytes(Object value, int estimateKeySize, int estimateValueSize) {
        Marshaller valueMarshaller = this.resolveValueMarshaller();
        return MarshallerUtil.obj2bytes(valueMarshaller, value, false, estimateKeySize, estimateValueSize);
    }

    public <T> T keyToObj(byte[] bytes, ClassWhiteList whitelist) {
        Marshaller keyMarshaller = this.resolveKeyMarshaller();
        return MarshallerUtil.bytes2obj(keyMarshaller, bytes, this.isObjectStorage, whitelist);
    }

    public <T> T valueToObj(byte[] bytes, ClassWhiteList whitelist) {
        Marshaller valueMarshaller = this.resolveValueMarshaller();
        return MarshallerUtil.bytes2obj(valueMarshaller, bytes, this.isObjectStorage, whitelist);
    }

    public String toString() {
        return "DataFormat{keyType=" + this.keyType + ", valueType=" + this.valueType + ", keyMarshaller=" + this.keyMarshaller + ", valueMarshaller=" + this.valueMarshaller + ", marshallerRegistry=" + this.marshallerRegistry + ", defaultMarshaller=" + this.defaultMarshaller + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MediaType keyType;
        private MediaType valueType;
        private Marshaller valueMarshaller;
        private Marshaller keyMarshaller;

        public Builder from(DataFormat dataFormat) {
            this.keyType = dataFormat.keyType;
            this.valueType = dataFormat.valueType;
            this.keyMarshaller = dataFormat.keyMarshaller;
            this.valueMarshaller = dataFormat.valueMarshaller;
            return this;
        }

        public Builder valueMarshaller(Marshaller valueMarshaller) {
            this.valueMarshaller = valueMarshaller;
            return this;
        }

        public Builder keyMarshaller(Marshaller keyMarshaller) {
            this.keyMarshaller = keyMarshaller;
            return this;
        }

        public Builder keyType(MediaType keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder valueType(MediaType valueType) {
            this.valueType = valueType;
            return this;
        }

        public DataFormat build() {
            return new DataFormat(this.keyType, this.valueType, this.keyMarshaller, this.valueMarshaller);
        }
    }
}

