/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.metadata.MetadataCollectionImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.multimap.MetadataCollection;

@Immutable
public class GetKeyWithMetadataMultimapOperation<V>
extends AbstractKeyOperation<MetadataCollection<V>> {
    private static final Log log = LogFactory.getLog(GetKeyWithMetadataMultimapOperation.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetKeyWithMetadataMultimapOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, DataFormat dataFormat) {
        super((short)105, (short)106, codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg, dataFormat);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.keyBytes);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(new MetadataCollectionImpl(Collections.emptySet()));
            return;
        }
        if (!HotRodConstants.isSuccess(status)) {
            this.complete(null);
            return;
        }
        short flags = buf.readByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        long version = buf.readLong();
        if (trace) {
            log.tracef("Received version: %d", version);
        }
        int size = ByteBufUtil.readVInt(buf);
        ArrayList values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object value = MarshallerUtil.bytes2obj(this.channelFactory.getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat.isObjectStorage(), this.cfg.getClassWhiteList());
            values.add(value);
        }
        this.complete(new MetadataCollectionImpl(values, creation, lifespan, lastUsed, maxIdle, version));
    }
}

