/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.DroppedConnectionsTest", groups={"functional"})
public class DroppedConnectionsTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache rc;
    private ChannelFactory channelFactory;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false)));
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.connectionPool().testWhileIdle(false).minIdle(1).maxIdle(2).maxActive(2).addServer().host(this.hotRodServer.getHost()).port(this.hotRodServer.getPort().intValue());
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.rc = this.remoteCacheManager.getCache();
        this.channelFactory = ((InternalRemoteCacheManager)this.remoteCacheManager).getChannelFactory();
        return this.cacheManager;
    }

    @AfterClass
    protected void teardown() {
        super.teardown();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testClosedConnection() throws Exception {
        this.rc.put((Object)"k", (Object)"v");
        InetSocketAddress address = InetSocketAddress.createUnresolved("127.0.0.1", this.hotRodServer.getPort());
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)address));
        AssertJUnit.assertEquals((int)1, (int)this.channelFactory.getNumIdle((SocketAddress)address));
        Channel channel = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).join();
        this.channelFactory.releaseChannel(channel);
        channel.close();
        AssertJUnit.assertEquals((Object)"v", (Object)this.rc.get((Object)"k"));
        AssertJUnit.assertEquals((int)0, (int)this.channelFactory.getNumActive((SocketAddress)address));
        AssertJUnit.assertEquals((int)1, (int)this.channelFactory.getNumIdle((SocketAddress)address));
        Channel channel2 = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).join();
        AssertJUnit.assertNotSame((Object)channel.id(), (Object)channel2.id());
    }
}

