/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.counter.BaseCounterAPITest;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.server.hotrod.counter.WeakCounterTestStrategy;
import org.infinispan.server.hotrod.counter.impl.WeakCounterImplTestStrategy;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.counter.WeakCounterAPITest")
public class WeakCounterAPITest
extends BaseCounterAPITest<WeakCounter>
implements WeakCounterTestStrategy {
    private final WeakCounterImplTestStrategy strategy = new WeakCounterImplTestStrategy(this::counterManager, this::counterManagers);

    public void testAdd(Method method) {
        this.strategy.testAdd(method);
    }

    public void testReset(Method method) {
        this.strategy.testReset(method);
    }

    public void testNameAndConfigurationTest(Method method) {
        this.strategy.testNameAndConfigurationTest(method);
    }

    public void testRemove(Method method) {
        this.strategy.testRemove(method);
    }

    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testListenerAddAndRemove(Method method) throws InterruptedException {
        this.strategy.testListenerAddAndRemove(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testExceptionInListener(Method method) throws InterruptedException {
        super.testExceptionInListener(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testConcurrentListenerAddAndRemove(Method method) throws InterruptedException {
        super.testConcurrentListenerAddAndRemove(method);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-9053")
    public void testListenerFailover(Method method) throws Exception {
        super.testListenerFailover(method);
    }

    @Override
    void increment(WeakCounter counter) {
        counter.sync().increment();
    }

    @Override
    void add(WeakCounter counter, long delta, long result) {
        this.strategy.add(counter, delta, result);
    }

    @Override
    WeakCounter defineAndCreateCounter(String counterName, long initialValue) {
        return this.strategy.defineAndCreateCounter(counterName, initialValue);
    }

    @Override
    <L extends CounterListener> Handle<L> addListenerTo(WeakCounter counter, L logger) {
        return this.strategy.addListenerTo(counter, logger);
    }

    @Override
    List<WeakCounter> getCounters(String name) {
        return this.counterManagers().stream().map(counterManager -> counterManager.getWeakCounter(name)).collect(Collectors.toList());
    }
}

